// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of data that is available for querying from this database.
 */
public class KxDatabaseConfiguration private constructor(builder: Builder) {
    /**
     * Configuration details for the disk cache used to increase performance reading from a kdb database mounted to the cluster.
     */
    public val cacheConfigurations: List<KxDatabaseCacheConfiguration>? = builder.cacheConfigurations
    /**
     * A unique identifier of the changeset that is associated with the cluster.
     */
    public val changesetId: kotlin.String? = builder.changesetId
    /**
     * The name of the kdb database. When this parameter is specified in the structure, S3 with the whole database is included by default.
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * The configuration of the dataview to be used with specified cluster.
     */
    public val dataviewConfiguration: aws.sdk.kotlin.services.finspace.model.KxDataviewConfiguration? = builder.dataviewConfiguration
    /**
     * The name of the dataview to be used for caching historical data on disk.
     */
    public val dataviewName: kotlin.String? = builder.dataviewName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxDatabaseConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxDatabaseConfiguration(")
        append("cacheConfigurations=$cacheConfigurations,")
        append("changesetId=$changesetId,")
        append("databaseName=$databaseName,")
        append("dataviewConfiguration=$dataviewConfiguration,")
        append("dataviewName=$dataviewName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheConfigurations?.hashCode() ?: 0
        result = 31 * result + (changesetId?.hashCode() ?: 0)
        result = 31 * result + (databaseName.hashCode())
        result = 31 * result + (dataviewConfiguration?.hashCode() ?: 0)
        result = 31 * result + (dataviewName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxDatabaseConfiguration

        if (cacheConfigurations != other.cacheConfigurations) return false
        if (changesetId != other.changesetId) return false
        if (databaseName != other.databaseName) return false
        if (dataviewConfiguration != other.dataviewConfiguration) return false
        if (dataviewName != other.dataviewName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxDatabaseConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configuration details for the disk cache used to increase performance reading from a kdb database mounted to the cluster.
         */
        public var cacheConfigurations: List<KxDatabaseCacheConfiguration>? = null
        /**
         * A unique identifier of the changeset that is associated with the cluster.
         */
        public var changesetId: kotlin.String? = null
        /**
         * The name of the kdb database. When this parameter is specified in the structure, S3 with the whole database is included by default.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The configuration of the dataview to be used with specified cluster.
         */
        public var dataviewConfiguration: aws.sdk.kotlin.services.finspace.model.KxDataviewConfiguration? = null
        /**
         * The name of the dataview to be used for caching historical data on disk.
         */
        public var dataviewName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxDatabaseConfiguration) : this() {
            this.cacheConfigurations = x.cacheConfigurations
            this.changesetId = x.changesetId
            this.databaseName = x.databaseName
            this.dataviewConfiguration = x.dataviewConfiguration
            this.dataviewName = x.dataviewName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxDatabaseConfiguration = KxDatabaseConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.KxDataviewConfiguration] inside the given [block]
         */
        public fun dataviewConfiguration(block: aws.sdk.kotlin.services.finspace.model.KxDataviewConfiguration.Builder.() -> kotlin.Unit) {
            this.dataviewConfiguration = aws.sdk.kotlin.services.finspace.model.KxDataviewConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            return this
        }
    }
}
