// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure of database cache configuration that is used for mapping database paths to cache types in clusters.
 */
public class KxDatabaseCacheConfiguration private constructor(builder: Builder) {
    /**
     * The type of disk cache. This parameter is used to map the database path to cache storage. The valid values are:
     * + CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
     */
    public val cacheType: kotlin.String = requireNotNull(builder.cacheType) { "A non-null value must be provided for cacheType" }
    /**
     * The name of the dataview to be used for caching historical data on disk.
     */
    public val dataviewName: kotlin.String? = builder.dataviewName
    /**
     * Specifies the portions of database that will be loaded into the cache for access.
     */
    public val dbPaths: List<String> = requireNotNull(builder.dbPaths) { "A non-null value must be provided for dbPaths" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxDatabaseCacheConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxDatabaseCacheConfiguration(")
        append("cacheType=$cacheType,")
        append("dataviewName=$dataviewName,")
        append("dbPaths=$dbPaths")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheType.hashCode()
        result = 31 * result + (dataviewName?.hashCode() ?: 0)
        result = 31 * result + (dbPaths.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxDatabaseCacheConfiguration

        if (cacheType != other.cacheType) return false
        if (dataviewName != other.dataviewName) return false
        if (dbPaths != other.dbPaths) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxDatabaseCacheConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of disk cache. This parameter is used to map the database path to cache storage. The valid values are:
         * + CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
         */
        public var cacheType: kotlin.String? = null
        /**
         * The name of the dataview to be used for caching historical data on disk.
         */
        public var dataviewName: kotlin.String? = null
        /**
         * Specifies the portions of database that will be loaded into the cache for access.
         */
        public var dbPaths: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxDatabaseCacheConfiguration) : this() {
            this.cacheType = x.cacheType
            this.dataviewName = x.dataviewName
            this.dbPaths = x.dbPaths
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxDatabaseCacheConfiguration = KxDatabaseCacheConfiguration(this)

        internal fun correctErrors(): Builder {
            if (cacheType == null) cacheType = ""
            if (dbPaths == null) dbPaths = emptyList()
            return this
        }
    }
}
