// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration that allows you to choose how you want to update code on a cluster. Depending on the option you choose, you can reduce the time it takes to update the cluster.
 */
public class KxClusterCodeDeploymentConfiguration private constructor(builder: Builder) {
    /**
     * The type of deployment that you want on a cluster.
     * + ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process with updated configuration.
     * + NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for `GP` type cluster. This option is quicker as it reduces the turn around time to update configuration on a cluster. With this deployment mode, you cannot update the `initializationScript` and `commandLineArguments` parameters.
     * + FORCE – This option updates the cluster by immediately stopping all the running processes before starting up new ones with the updated configuration.
     */
    public val deploymentStrategy: aws.sdk.kotlin.services.finspace.model.KxClusterCodeDeploymentStrategy = requireNotNull(builder.deploymentStrategy) { "A non-null value must be provided for deploymentStrategy" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxClusterCodeDeploymentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxClusterCodeDeploymentConfiguration(")
        append("deploymentStrategy=$deploymentStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentStrategy.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxClusterCodeDeploymentConfiguration

        if (deploymentStrategy != other.deploymentStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxClusterCodeDeploymentConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of deployment that you want on a cluster.
         * + ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process with updated configuration.
         * + NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for `GP` type cluster. This option is quicker as it reduces the turn around time to update configuration on a cluster. With this deployment mode, you cannot update the `initializationScript` and `commandLineArguments` parameters.
         * + FORCE – This option updates the cluster by immediately stopping all the running processes before starting up new ones with the updated configuration.
         */
        public var deploymentStrategy: aws.sdk.kotlin.services.finspace.model.KxClusterCodeDeploymentStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxClusterCodeDeploymentConfiguration) : this() {
            this.deploymentStrategy = x.deploymentStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxClusterCodeDeploymentConfiguration = KxClusterCodeDeploymentConfiguration(this)

        internal fun correctErrors(): Builder {
            if (deploymentStrategy == null) deploymentStrategy = KxClusterCodeDeploymentStrategy.SdkUnknown("no value provided")
            return this
        }
    }
}
