// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetKxScalingGroupResponse private constructor(builder: Builder) {
    /**
     * The identifier of the availability zones.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The list of Managed kdb clusters that are currently active in the given scaling group.
     */
    public val clusters: List<String>? = builder.clusters
    /**
     * The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
     *
     * It can have one of the following values:
     * + `kx.sg.large` – The host type with a configuration of 16 GiB memory and 2 vCPUs.
     * + `kx.sg.xlarge` – The host type with a configuration of 32 GiB memory and 4 vCPUs.
     * + `kx.sg.2xlarge` – The host type with a configuration of 64 GiB memory and 8 vCPUs.
     * + `kx.sg.4xlarge` – The host type with a configuration of 108 GiB memory and 16 vCPUs.
     * + `kx.sg.8xlarge` – The host type with a configuration of 216 GiB memory and 32 vCPUs.
     * + `kx.sg.16xlarge` – The host type with a configuration of 432 GiB memory and 64 vCPUs.
     * + `kx.sg.32xlarge` – The host type with a configuration of 864 GiB memory and 128 vCPUs.
     * + `kx.sg1.16xlarge` – The host type with a configuration of 1949 GiB memory and 64 vCPUs.
     * + `kx.sg1.24xlarge` – The host type with a configuration of 2948 GiB memory and 96 vCPUs.
     */
    public val hostType: kotlin.String? = builder.hostType
    /**
     * The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimestamp
    /**
     * The ARN identifier for the scaling group.
     */
    public val scalingGroupArn: kotlin.String? = builder.scalingGroupArn
    /**
     * A unique identifier for the kdb scaling group.
     */
    public val scalingGroupName: kotlin.String? = builder.scalingGroupName
    /**
     * The status of scaling group.
     * + CREATING – The scaling group creation is in progress.
     * + CREATE_FAILED – The scaling group creation has failed.
     * + ACTIVE – The scaling group is active.
     * + UPDATING – The scaling group is in the process of being updated.
     * + UPDATE_FAILED – The update action failed.
     * + DELETING – The scaling group is in the process of being deleted.
     * + DELETE_FAILED – The system failed to delete the scaling group.
     * + DELETED – The scaling group is successfully deleted.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.KxScalingGroupStatus? = builder.status
    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.GetKxScalingGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetKxScalingGroupResponse(")
        append("availabilityZoneId=$availabilityZoneId,")
        append("clusters=$clusters,")
        append("createdTimestamp=$createdTimestamp,")
        append("hostType=$hostType,")
        append("lastModifiedTimestamp=$lastModifiedTimestamp,")
        append("scalingGroupArn=$scalingGroupArn,")
        append("scalingGroupName=$scalingGroupName,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneId?.hashCode() ?: 0
        result = 31 * result + (clusters?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (hostType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (scalingGroupArn?.hashCode() ?: 0)
        result = 31 * result + (scalingGroupName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetKxScalingGroupResponse

        if (availabilityZoneId != other.availabilityZoneId) return false
        if (clusters != other.clusters) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (hostType != other.hostType) return false
        if (lastModifiedTimestamp != other.lastModifiedTimestamp) return false
        if (scalingGroupArn != other.scalingGroupArn) return false
        if (scalingGroupName != other.scalingGroupName) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.GetKxScalingGroupResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the availability zones.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * The list of Managed kdb clusters that are currently active in the given scaling group.
         */
        public var clusters: List<String>? = null
        /**
         * The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
         *
         * It can have one of the following values:
         * + `kx.sg.large` – The host type with a configuration of 16 GiB memory and 2 vCPUs.
         * + `kx.sg.xlarge` – The host type with a configuration of 32 GiB memory and 4 vCPUs.
         * + `kx.sg.2xlarge` – The host type with a configuration of 64 GiB memory and 8 vCPUs.
         * + `kx.sg.4xlarge` – The host type with a configuration of 108 GiB memory and 16 vCPUs.
         * + `kx.sg.8xlarge` – The host type with a configuration of 216 GiB memory and 32 vCPUs.
         * + `kx.sg.16xlarge` – The host type with a configuration of 432 GiB memory and 64 vCPUs.
         * + `kx.sg.32xlarge` – The host type with a configuration of 864 GiB memory and 128 vCPUs.
         * + `kx.sg1.16xlarge` – The host type with a configuration of 1949 GiB memory and 64 vCPUs.
         * + `kx.sg1.24xlarge` – The host type with a configuration of 2948 GiB memory and 96 vCPUs.
         */
        public var hostType: kotlin.String? = null
        /**
         * The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN identifier for the scaling group.
         */
        public var scalingGroupArn: kotlin.String? = null
        /**
         * A unique identifier for the kdb scaling group.
         */
        public var scalingGroupName: kotlin.String? = null
        /**
         * The status of scaling group.
         * + CREATING – The scaling group creation is in progress.
         * + CREATE_FAILED – The scaling group creation has failed.
         * + ACTIVE – The scaling group is active.
         * + UPDATING – The scaling group is in the process of being updated.
         * + UPDATE_FAILED – The update action failed.
         * + DELETING – The scaling group is in the process of being deleted.
         * + DELETE_FAILED – The system failed to delete the scaling group.
         * + DELETED – The scaling group is successfully deleted.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.KxScalingGroupStatus? = null
        /**
         * The error message when a failed state occurs.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.GetKxScalingGroupResponse) : this() {
            this.availabilityZoneId = x.availabilityZoneId
            this.clusters = x.clusters
            this.createdTimestamp = x.createdTimestamp
            this.hostType = x.hostType
            this.lastModifiedTimestamp = x.lastModifiedTimestamp
            this.scalingGroupArn = x.scalingGroupArn
            this.scalingGroupName = x.scalingGroupName
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.GetKxScalingGroupResponse = GetKxScalingGroupResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
