// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateKxVolumeResponse private constructor(builder: Builder) {
    /**
     * The identifier of the availability zones.
     */
    public val availabilityZoneIds: List<String>? = builder.availabilityZoneIds
    /**
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports `SINGLE` for volumes. This places dataview in a single AZ.
     */
    public val azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = builder.azMode
    /**
     * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * A description of the volume.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the kdb environment, whose clusters can attach to the volume.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * Specifies the configuration for the Network attached storage (NAS_1) file system volume.
     */
    public val nas1Configuration: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration? = builder.nas1Configuration
    /**
     * The status of volume creation.
     * + CREATING – The volume creation is in progress.
     * + CREATE_FAILED – The volume creation has failed.
     * + ACTIVE – The volume is active.
     * + UPDATING – The volume is in the process of being updated.
     * + UPDATE_FAILED – The update action failed.
     * + UPDATED – The volume is successfully updated.
     * + DELETING – The volume is in the process of being deleted.
     * + DELETE_FAILED – The system failed to delete the volume.
     * + DELETED – The volume is successfully deleted.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.KxVolumeStatus? = builder.status
    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The ARN identifier of the volume.
     */
    public val volumeArn: kotlin.String? = builder.volumeArn
    /**
     * A unique identifier for the volume.
     */
    public val volumeName: kotlin.String? = builder.volumeName
    /**
     * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type.
     */
    public val volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.CreateKxVolumeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKxVolumeResponse(")
        append("availabilityZoneIds=$availabilityZoneIds,")
        append("azMode=$azMode,")
        append("createdTimestamp=$createdTimestamp,")
        append("description=$description,")
        append("environmentId=$environmentId,")
        append("nas1Configuration=$nas1Configuration,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("volumeArn=$volumeArn,")
        append("volumeName=$volumeName,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneIds?.hashCode() ?: 0
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (nas1Configuration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeName?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKxVolumeResponse

        if (availabilityZoneIds != other.availabilityZoneIds) return false
        if (azMode != other.azMode) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (description != other.description) return false
        if (environmentId != other.environmentId) return false
        if (nas1Configuration != other.nas1Configuration) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeName != other.volumeName) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.CreateKxVolumeResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the availability zones.
         */
        public var availabilityZoneIds: List<String>? = null
        /**
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports `SINGLE` for volumes. This places dataview in a single AZ.
         */
        public var azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = null
        /**
         * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the volume.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the kdb environment, whose clusters can attach to the volume.
         */
        public var environmentId: kotlin.String? = null
        /**
         * Specifies the configuration for the Network attached storage (NAS_1) file system volume.
         */
        public var nas1Configuration: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration? = null
        /**
         * The status of volume creation.
         * + CREATING – The volume creation is in progress.
         * + CREATE_FAILED – The volume creation has failed.
         * + ACTIVE – The volume is active.
         * + UPDATING – The volume is in the process of being updated.
         * + UPDATE_FAILED – The update action failed.
         * + UPDATED – The volume is successfully updated.
         * + DELETING – The volume is in the process of being deleted.
         * + DELETE_FAILED – The system failed to delete the volume.
         * + DELETED – The volume is successfully deleted.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.KxVolumeStatus? = null
        /**
         * The error message when a failed state occurs.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The ARN identifier of the volume.
         */
        public var volumeArn: kotlin.String? = null
        /**
         * A unique identifier for the volume.
         */
        public var volumeName: kotlin.String? = null
        /**
         * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type.
         */
        public var volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.CreateKxVolumeResponse) : this() {
            this.availabilityZoneIds = x.availabilityZoneIds
            this.azMode = x.azMode
            this.createdTimestamp = x.createdTimestamp
            this.description = x.description
            this.environmentId = x.environmentId
            this.nas1Configuration = x.nas1Configuration
            this.status = x.status
            this.statusReason = x.statusReason
            this.volumeArn = x.volumeArn
            this.volumeName = x.volumeName
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.CreateKxVolumeResponse = CreateKxVolumeResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.KxNas1Configuration] inside the given [block]
         */
        public fun nas1Configuration(block: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration.Builder.() -> kotlin.Unit) {
            this.nas1Configuration = aws.sdk.kotlin.services.finspace.model.KxNas1Configuration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
