// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateKxVolumeRequest private constructor(builder: Builder) {
    /**
     * The identifier of the availability zones.
     */
    public val availabilityZoneIds: List<String>? = builder.availabilityZoneIds
    /**
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports `SINGLE` for volumes. This places dataview in a single AZ.
     */
    public val azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = builder.azMode
    /**
     * A token that ensures idempotency. This token expires in 10 minutes.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description of the volume.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the kdb environment, whose clusters can attach to the volume.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * Specifies the configuration for the Network attached storage (NAS_1) file system volume. This parameter is required when you choose `volumeType` as *NAS_1*.
     */
    public val nas1Configuration: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration? = builder.nas1Configuration
    /**
     * A list of key-value pairs to label the volume. You can add up to 50 tags to a volume.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A unique identifier for the volume.
     */
    public val volumeName: kotlin.String? = builder.volumeName
    /**
     * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type. When you select `NAS_1` volume type, you must also provide `nas1Configuration`.
     */
    public val volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.CreateKxVolumeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKxVolumeRequest(")
        append("availabilityZoneIds=$availabilityZoneIds,")
        append("azMode=$azMode,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("environmentId=$environmentId,")
        append("nas1Configuration=$nas1Configuration,")
        append("tags=$tags,")
        append("volumeName=$volumeName,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneIds?.hashCode() ?: 0
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (nas1Configuration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeName?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKxVolumeRequest

        if (availabilityZoneIds != other.availabilityZoneIds) return false
        if (azMode != other.azMode) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (environmentId != other.environmentId) return false
        if (nas1Configuration != other.nas1Configuration) return false
        if (tags != other.tags) return false
        if (volumeName != other.volumeName) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.CreateKxVolumeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the availability zones.
         */
        public var availabilityZoneIds: List<String>? = null
        /**
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports `SINGLE` for volumes. This places dataview in a single AZ.
         */
        public var azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = null
        /**
         * A token that ensures idempotency. This token expires in 10 minutes.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description of the volume.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the kdb environment, whose clusters can attach to the volume.
         */
        public var environmentId: kotlin.String? = null
        /**
         * Specifies the configuration for the Network attached storage (NAS_1) file system volume. This parameter is required when you choose `volumeType` as *NAS_1*.
         */
        public var nas1Configuration: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration? = null
        /**
         * A list of key-value pairs to label the volume. You can add up to 50 tags to a volume.
         */
        public var tags: Map<String, String>? = null
        /**
         * A unique identifier for the volume.
         */
        public var volumeName: kotlin.String? = null
        /**
         * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type. When you select `NAS_1` volume type, you must also provide `nas1Configuration`.
         */
        public var volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.CreateKxVolumeRequest) : this() {
            this.availabilityZoneIds = x.availabilityZoneIds
            this.azMode = x.azMode
            this.clientToken = x.clientToken
            this.description = x.description
            this.environmentId = x.environmentId
            this.nas1Configuration = x.nas1Configuration
            this.tags = x.tags
            this.volumeName = x.volumeName
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.CreateKxVolumeRequest = CreateKxVolumeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.KxNas1Configuration] inside the given [block]
         */
        public fun nas1Configuration(block: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration.Builder.() -> kotlin.Unit) {
            this.nas1Configuration = aws.sdk.kotlin.services.finspace.model.KxNas1Configuration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
