// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateKxChangesetRequest private constructor(builder: Builder) {
    /**
     * A list of change request objects that are run in order. A change request object consists of `changeType` , `s3Path`, and `dbPath`. A changeType can have the following values:
     * + PUT – Adds or updates files in a database.
     * + DELETE – Deletes files in a database.
     *
     * All the change requests require a mandatory `dbPath` attribute that defines the path within the database directory. All database paths must start with a leading / and end with a trailing /. The `s3Path` attribute defines the s3 source file path and is required for a PUT change type. The `s3path` must end with a trailing / if it is a directory and must end without a trailing / if it is a file.
     *
     * Here are few examples of how you can use the change request object:
     * + This request adds a single sym file at database root location. `{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}`
     * + This request adds files in the given `s3Path` under the 2020.01.02 partition of the database.`{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}`
     * + This request adds files in the given `s3Path` under the *taq* table partition of the database.`[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]`
     * + This request deletes the 2020.01.02 partition of the database.`[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]`
     * + The *DELETE* request allows you to delete the existing files under the 2020.01.02 partition of the database, and the *PUT* request adds a new taq table under it.`[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]`
     */
    public val changeRequests: List<ChangeRequest>? = builder.changeRequests
    /**
     * A token that ensures idempotency. This token expires in 10 minutes.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the kdb database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * A unique identifier of the kdb environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.CreateKxChangesetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKxChangesetRequest(")
        append("changeRequests=$changeRequests,")
        append("clientToken=$clientToken,")
        append("databaseName=$databaseName,")
        append("environmentId=$environmentId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeRequests?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKxChangesetRequest

        if (changeRequests != other.changeRequests) return false
        if (clientToken != other.clientToken) return false
        if (databaseName != other.databaseName) return false
        if (environmentId != other.environmentId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.CreateKxChangesetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of change request objects that are run in order. A change request object consists of `changeType` , `s3Path`, and `dbPath`. A changeType can have the following values:
         * + PUT – Adds or updates files in a database.
         * + DELETE – Deletes files in a database.
         *
         * All the change requests require a mandatory `dbPath` attribute that defines the path within the database directory. All database paths must start with a leading / and end with a trailing /. The `s3Path` attribute defines the s3 source file path and is required for a PUT change type. The `s3path` must end with a trailing / if it is a directory and must end without a trailing / if it is a file.
         *
         * Here are few examples of how you can use the change request object:
         * + This request adds a single sym file at database root location. `{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}`
         * + This request adds files in the given `s3Path` under the 2020.01.02 partition of the database.`{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}`
         * + This request adds files in the given `s3Path` under the *taq* table partition of the database.`[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]`
         * + This request deletes the 2020.01.02 partition of the database.`[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]`
         * + The *DELETE* request allows you to delete the existing files under the 2020.01.02 partition of the database, and the *PUT* request adds a new taq table under it.`[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]`
         */
        public var changeRequests: List<ChangeRequest>? = null
        /**
         * A token that ensures idempotency. This token expires in 10 minutes.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the kdb database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * A unique identifier of the kdb environment.
         */
        public var environmentId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.CreateKxChangesetRequest) : this() {
            this.changeRequests = x.changeRequests
            this.clientToken = x.clientToken
            this.databaseName = x.databaseName
            this.environmentId = x.environmentId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.CreateKxChangesetRequest = CreateKxChangesetRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
