// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure of the customer code available within the running cluster.
 */
public class CodeConfiguration private constructor(builder: Builder) {
    /**
     * A unique name for the S3 bucket.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The full S3 path (excluding bucket) to the .zip file. This file contains the code that is loaded onto the cluster when it's started.
     */
    public val s3Key: kotlin.String? = builder.s3Key
    /**
     * The version of an S3 object.
     */
    public val s3ObjectVersion: kotlin.String? = builder.s3ObjectVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.CodeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeConfiguration(")
        append("s3Bucket=$s3Bucket,")
        append("s3Key=$s3Key,")
        append("s3ObjectVersion=$s3ObjectVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Bucket?.hashCode() ?: 0
        result = 31 * result + (s3Key?.hashCode() ?: 0)
        result = 31 * result + (s3ObjectVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeConfiguration

        if (s3Bucket != other.s3Bucket) return false
        if (s3Key != other.s3Key) return false
        if (s3ObjectVersion != other.s3ObjectVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.CodeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique name for the S3 bucket.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The full S3 path (excluding bucket) to the .zip file. This file contains the code that is loaded onto the cluster when it's started.
         */
        public var s3Key: kotlin.String? = null
        /**
         * The version of an S3 object.
         */
        public var s3ObjectVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.CodeConfiguration) : this() {
            this.s3Bucket = x.s3Bucket
            this.s3Key = x.s3Key
            this.s3ObjectVersion = x.s3ObjectVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.CodeConfiguration = CodeConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
