// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and number of instances.
 */
public class CapacityConfiguration private constructor(builder: Builder) {
    /**
     * The number of instances running in a cluster.
     */
    public val nodeCount: kotlin.Int? = builder.nodeCount
    /**
     * The type that determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.
     *
     * You can only specify one of the following values:
     * + `kx.s.large` – The node type with a configuration of 12 GiB memory and 2 vCPUs.
     * + `kx.s.xlarge` – The node type with a configuration of 27 GiB memory and 4 vCPUs.
     * + `kx.s.2xlarge` – The node type with a configuration of 54 GiB memory and 8 vCPUs.
     * + `kx.s.4xlarge` – The node type with a configuration of 108 GiB memory and 16 vCPUs.
     * + `kx.s.8xlarge` – The node type with a configuration of 216 GiB memory and 32 vCPUs.
     * + `kx.s.16xlarge` – The node type with a configuration of 432 GiB memory and 64 vCPUs.
     * + `kx.s.32xlarge` – The node type with a configuration of 864 GiB memory and 128 vCPUs.
     */
    public val nodeType: kotlin.String? = builder.nodeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.CapacityConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityConfiguration(")
        append("nodeCount=$nodeCount,")
        append("nodeType=$nodeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nodeCount ?: 0
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityConfiguration

        if (nodeCount != other.nodeCount) return false
        if (nodeType != other.nodeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.CapacityConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of instances running in a cluster.
         */
        public var nodeCount: kotlin.Int? = null
        /**
         * The type that determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.
         *
         * You can only specify one of the following values:
         * + `kx.s.large` – The node type with a configuration of 12 GiB memory and 2 vCPUs.
         * + `kx.s.xlarge` – The node type with a configuration of 27 GiB memory and 4 vCPUs.
         * + `kx.s.2xlarge` – The node type with a configuration of 54 GiB memory and 8 vCPUs.
         * + `kx.s.4xlarge` – The node type with a configuration of 108 GiB memory and 16 vCPUs.
         * + `kx.s.8xlarge` – The node type with a configuration of 216 GiB memory and 32 vCPUs.
         * + `kx.s.16xlarge` – The node type with a configuration of 432 GiB memory and 64 vCPUs.
         * + `kx.s.32xlarge` – The node type with a configuration of 864 GiB memory and 128 vCPUs.
         */
        public var nodeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.CapacityConfiguration) : this() {
            this.nodeCount = x.nodeCount
            this.nodeType = x.nodeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.CapacityConfiguration = CapacityConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
