// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.finspace.auth.DefaultFinspaceAuthSchemeProvider
import aws.sdk.kotlin.services.finspace.auth.FinspaceAuthSchemeProvider
import aws.sdk.kotlin.services.finspace.endpoints.DefaultFinspaceEndpointProvider
import aws.sdk.kotlin.services.finspace.endpoints.FinspaceEndpointParameters
import aws.sdk.kotlin.services.finspace.endpoints.FinspaceEndpointProvider
import aws.sdk.kotlin.services.finspace.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxChangesetRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxChangesetResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxClusterRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxClusterResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxDatabaseRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxDatabaseResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxDataviewRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxDataviewResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxScalingGroupRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxScalingGroupResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxUserRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxUserResponse
import aws.sdk.kotlin.services.finspace.model.CreateKxVolumeRequest
import aws.sdk.kotlin.services.finspace.model.CreateKxVolumeResponse
import aws.sdk.kotlin.services.finspace.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxClusterNodeRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxClusterNodeResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxClusterRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxClusterResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxDatabaseRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxDatabaseResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxDataviewRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxDataviewResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxScalingGroupRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxScalingGroupResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxUserRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxUserResponse
import aws.sdk.kotlin.services.finspace.model.DeleteKxVolumeRequest
import aws.sdk.kotlin.services.finspace.model.DeleteKxVolumeResponse
import aws.sdk.kotlin.services.finspace.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.GetKxChangesetRequest
import aws.sdk.kotlin.services.finspace.model.GetKxChangesetResponse
import aws.sdk.kotlin.services.finspace.model.GetKxClusterRequest
import aws.sdk.kotlin.services.finspace.model.GetKxClusterResponse
import aws.sdk.kotlin.services.finspace.model.GetKxConnectionStringRequest
import aws.sdk.kotlin.services.finspace.model.GetKxConnectionStringResponse
import aws.sdk.kotlin.services.finspace.model.GetKxDatabaseRequest
import aws.sdk.kotlin.services.finspace.model.GetKxDatabaseResponse
import aws.sdk.kotlin.services.finspace.model.GetKxDataviewRequest
import aws.sdk.kotlin.services.finspace.model.GetKxDataviewResponse
import aws.sdk.kotlin.services.finspace.model.GetKxEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.GetKxEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.GetKxScalingGroupRequest
import aws.sdk.kotlin.services.finspace.model.GetKxScalingGroupResponse
import aws.sdk.kotlin.services.finspace.model.GetKxUserRequest
import aws.sdk.kotlin.services.finspace.model.GetKxUserResponse
import aws.sdk.kotlin.services.finspace.model.GetKxVolumeRequest
import aws.sdk.kotlin.services.finspace.model.GetKxVolumeResponse
import aws.sdk.kotlin.services.finspace.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.finspace.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxChangesetsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxChangesetsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxClusterNodesRequest
import aws.sdk.kotlin.services.finspace.model.ListKxClusterNodesResponse
import aws.sdk.kotlin.services.finspace.model.ListKxClustersRequest
import aws.sdk.kotlin.services.finspace.model.ListKxClustersResponse
import aws.sdk.kotlin.services.finspace.model.ListKxDatabasesRequest
import aws.sdk.kotlin.services.finspace.model.ListKxDatabasesResponse
import aws.sdk.kotlin.services.finspace.model.ListKxDataviewsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxDataviewsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxEnvironmentsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxEnvironmentsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxScalingGroupsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxScalingGroupsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxUsersRequest
import aws.sdk.kotlin.services.finspace.model.ListKxUsersResponse
import aws.sdk.kotlin.services.finspace.model.ListKxVolumesRequest
import aws.sdk.kotlin.services.finspace.model.ListKxVolumesResponse
import aws.sdk.kotlin.services.finspace.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.finspace.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.finspace.model.TagResourceRequest
import aws.sdk.kotlin.services.finspace.model.TagResourceResponse
import aws.sdk.kotlin.services.finspace.model.UntagResourceRequest
import aws.sdk.kotlin.services.finspace.model.UntagResourceResponse
import aws.sdk.kotlin.services.finspace.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.UpdateEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxClusterCodeConfigurationRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxClusterCodeConfigurationResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxClusterDatabasesRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxClusterDatabasesResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxDatabaseRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxDatabaseResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxDataviewRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxDataviewResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxEnvironmentNetworkRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxEnvironmentNetworkResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxEnvironmentRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxEnvironmentResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxUserRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxUserResponse
import aws.sdk.kotlin.services.finspace.model.UpdateKxVolumeRequest
import aws.sdk.kotlin.services.finspace.model.UpdateKxVolumeResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "finspace"
public const val SdkVersion: String = "1.3.45"
public const val ServiceApiVersion: String = "2021-03-12"

/**
 * The FinSpace management service provides the APIs for managing FinSpace environments.
 */
public interface FinspaceClient : SdkClient {
    /**
     * FinspaceClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, FinspaceClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Finspace",
                "FINSPACE",
                "finspace",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, FinspaceClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): FinspaceClient = DefaultFinspaceClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: FinspaceEndpointProvider = builder.endpointProvider ?: DefaultFinspaceEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: FinspaceAuthSchemeProvider = builder.authSchemeProvider ?: DefaultFinspaceAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "finspace"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: FinspaceEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: FinspaceAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Create a new FinSpace environment.
     */
    @Deprecated("This method will be discontinued.")
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an ordered list of change requests.
     */
    public suspend fun createKxChangeset(input: CreateKxChangesetRequest): CreateKxChangesetResponse

    /**
     * Creates a new kdb cluster.
     */
    public suspend fun createKxCluster(input: CreateKxClusterRequest): CreateKxClusterResponse

    /**
     * Creates a new kdb database in the environment.
     */
    public suspend fun createKxDatabase(input: CreateKxDatabaseRequest): CreateKxDatabaseResponse

    /**
     * Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on kdb clusters. Dataviews are only available for clusters running on a scaling group. They are not supported on dedicated clusters.
     */
    public suspend fun createKxDataview(input: CreateKxDataviewRequest): CreateKxDataviewResponse

    /**
     * Creates a managed kdb environment for the account.
     */
    public suspend fun createKxEnvironment(input: CreateKxEnvironmentRequest): CreateKxEnvironmentResponse

    /**
     * Creates a new scaling group.
     */
    public suspend fun createKxScalingGroup(input: CreateKxScalingGroupRequest): CreateKxScalingGroupResponse

    /**
     * Creates a user in FinSpace kdb environment with an associated IAM role.
     */
    public suspend fun createKxUser(input: CreateKxUserRequest): CreateKxUserResponse

    /**
     * Creates a new volume with a specific amount of throughput and storage capacity.
     */
    public suspend fun createKxVolume(input: CreateKxVolumeRequest): CreateKxVolumeResponse

    /**
     * Delete an FinSpace environment.
     */
    @Deprecated("This method will be discontinued.")
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes a kdb cluster.
     */
    public suspend fun deleteKxCluster(input: DeleteKxClusterRequest): DeleteKxClusterResponse

    /**
     * Deletes the specified nodes from a cluster.
     */
    public suspend fun deleteKxClusterNode(input: DeleteKxClusterNodeRequest): DeleteKxClusterNodeResponse

    /**
     * Deletes the specified database and all of its associated data. This action is irreversible. You must copy any data out of the database before deleting it if the data is to be retained.
     */
    public suspend fun deleteKxDatabase(input: DeleteKxDatabaseRequest): DeleteKxDatabaseResponse

    /**
     * Deletes the specified dataview. Before deleting a dataview, make sure that it is not in use by any cluster.
     */
    public suspend fun deleteKxDataview(input: DeleteKxDataviewRequest): DeleteKxDataviewResponse

    /**
     * Deletes the kdb environment. This action is irreversible. Deleting a kdb environment will remove all the associated data and any services running in it.
     */
    public suspend fun deleteKxEnvironment(input: DeleteKxEnvironmentRequest): DeleteKxEnvironmentResponse

    /**
     * Deletes the specified scaling group. This action is irreversible. You cannot delete a scaling group until all the clusters running on it have been deleted.
     */
    public suspend fun deleteKxScalingGroup(input: DeleteKxScalingGroupRequest): DeleteKxScalingGroupResponse

    /**
     * Deletes a user in the specified kdb environment.
     */
    public suspend fun deleteKxUser(input: DeleteKxUserRequest): DeleteKxUserResponse

    /**
     * Deletes a volume. You can only delete a volume if it's not attached to a cluster or a dataview. When a volume is deleted, any data on the volume is lost. This action is irreversible.
     */
    public suspend fun deleteKxVolume(input: DeleteKxVolumeRequest): DeleteKxVolumeResponse

    /**
     * Returns the FinSpace environment object.
     */
    @Deprecated("This method will be discontinued.")
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * Returns information about a kdb changeset.
     */
    public suspend fun getKxChangeset(input: GetKxChangesetRequest): GetKxChangesetResponse

    /**
     * Retrieves information about a kdb cluster.
     */
    public suspend fun getKxCluster(input: GetKxClusterRequest): GetKxClusterResponse

    /**
     * Retrieves a connection string for a user to connect to a kdb cluster. You must call this API using the same role that you have defined while creating a user.
     */
    public suspend fun getKxConnectionString(input: GetKxConnectionStringRequest): GetKxConnectionStringResponse

    /**
     * Returns database information for the specified environment ID.
     */
    public suspend fun getKxDatabase(input: GetKxDatabaseRequest): GetKxDatabaseResponse

    /**
     * Retrieves details of the dataview.
     */
    public suspend fun getKxDataview(input: GetKxDataviewRequest): GetKxDataviewResponse

    /**
     * Retrieves all the information for the specified kdb environment.
     */
    public suspend fun getKxEnvironment(input: GetKxEnvironmentRequest): GetKxEnvironmentResponse

    /**
     * Retrieves details of a scaling group.
     */
    public suspend fun getKxScalingGroup(input: GetKxScalingGroupRequest): GetKxScalingGroupResponse

    /**
     * Retrieves information about the specified kdb user.
     */
    public suspend fun getKxUser(input: GetKxUserRequest): GetKxUserResponse

    /**
     * Retrieves the information about the volume.
     */
    public suspend fun getKxVolume(input: GetKxVolumeRequest): GetKxVolumeResponse

    /**
     * A list of all of your FinSpace environments.
     */
    @Deprecated("This method will be discontinued.")
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest { }): ListEnvironmentsResponse

    /**
     * Returns a list of all the changesets for a database.
     */
    public suspend fun listKxChangesets(input: ListKxChangesetsRequest): ListKxChangesetsResponse

    /**
     * Lists all the nodes in a kdb cluster.
     */
    public suspend fun listKxClusterNodes(input: ListKxClusterNodesRequest): ListKxClusterNodesResponse

    /**
     * Returns a list of clusters.
     */
    public suspend fun listKxClusters(input: ListKxClustersRequest): ListKxClustersResponse

    /**
     * Returns a list of all the databases in the kdb environment.
     */
    public suspend fun listKxDatabases(input: ListKxDatabasesRequest): ListKxDatabasesResponse

    /**
     * Returns a list of all the dataviews in the database.
     */
    public suspend fun listKxDataviews(input: ListKxDataviewsRequest): ListKxDataviewsResponse

    /**
     * Returns a list of kdb environments created in an account.
     */
    public suspend fun listKxEnvironments(input: ListKxEnvironmentsRequest = ListKxEnvironmentsRequest { }): ListKxEnvironmentsResponse

    /**
     * Returns a list of scaling groups in a kdb environment.
     */
    public suspend fun listKxScalingGroups(input: ListKxScalingGroupsRequest): ListKxScalingGroupsResponse

    /**
     * Lists all the users in a kdb environment.
     */
    public suspend fun listKxUsers(input: ListKxUsersRequest): ListKxUsersResponse

    /**
     * Lists all the volumes in a kdb environment.
     */
    public suspend fun listKxVolumes(input: ListKxVolumesRequest): ListKxVolumesResponse

    /**
     * A list of all tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds metadata tags to a FinSpace resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes metadata tags from a FinSpace resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update your FinSpace environment.
     */
    @Deprecated("This method will be discontinued.")
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Allows you to update code configuration on a running cluster. By using this API you can update the code, the initialization script path, and the command line arguments for a specific cluster. The configuration that you want to update will override any existing configurations on the cluster.
     */
    public suspend fun updateKxClusterCodeConfiguration(input: UpdateKxClusterCodeConfigurationRequest): UpdateKxClusterCodeConfigurationResponse

    /**
     * Updates the databases mounted on a kdb cluster, which includes the `changesetId` and all the dbPaths to be cached. This API does not allow you to change a database name or add a database if you created a cluster without one.
     *
     * Using this API you can point a cluster to a different changeset and modify a list of partitions being cached.
     */
    public suspend fun updateKxClusterDatabases(input: UpdateKxClusterDatabasesRequest): UpdateKxClusterDatabasesResponse

    /**
     * Updates information for the given kdb database.
     */
    public suspend fun updateKxDatabase(input: UpdateKxDatabaseRequest): UpdateKxDatabaseResponse

    /**
     * Updates the specified dataview. The dataviews get automatically updated when any new changesets are ingested. Each update of the dataview creates a new version, including changeset details and cache configurations
     */
    public suspend fun updateKxDataview(input: UpdateKxDataviewRequest): UpdateKxDataviewResponse

    /**
     * Updates information for the given kdb environment.
     */
    public suspend fun updateKxEnvironment(input: UpdateKxEnvironmentRequest): UpdateKxEnvironmentResponse

    /**
     * Updates environment network to connect to your internal network by using a transit gateway. This API supports request to create a transit gateway attachment from FinSpace VPC to your transit gateway ID and create a custom Route-53 outbound resolvers.
     *
     * Once you send a request to update a network, you cannot change it again. Network update might require termination of any clusters that are running in the existing network.
     */
    public suspend fun updateKxEnvironmentNetwork(input: UpdateKxEnvironmentNetworkRequest): UpdateKxEnvironmentNetworkResponse

    /**
     * Updates the user details. You can only update the IAM role associated with a user.
     */
    public suspend fun updateKxUser(input: UpdateKxUserRequest): UpdateKxUserResponse

    /**
     * Updates the throughput or capacity of a volume. During the update process, the filesystem might be unavailable for a few minutes. You can retry any operations after the update is complete.
     */
    public suspend fun updateKxVolume(input: UpdateKxVolumeRequest): UpdateKxVolumeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun FinspaceClient.withConfig(block: FinspaceClient.Config.Builder.() -> Unit): FinspaceClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultFinspaceClient(newConfig)
}

/**
 * Create a new FinSpace environment.
 */
@Deprecated("This method will be discontinued.")
public suspend inline fun FinspaceClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an ordered list of change requests.
 */
public suspend inline fun FinspaceClient.createKxChangeset(crossinline block: CreateKxChangesetRequest.Builder.() -> Unit): CreateKxChangesetResponse = createKxChangeset(CreateKxChangesetRequest.Builder().apply(block).build())

/**
 * Creates a new kdb cluster.
 */
public suspend inline fun FinspaceClient.createKxCluster(crossinline block: CreateKxClusterRequest.Builder.() -> Unit): CreateKxClusterResponse = createKxCluster(CreateKxClusterRequest.Builder().apply(block).build())

/**
 * Creates a new kdb database in the environment.
 */
public suspend inline fun FinspaceClient.createKxDatabase(crossinline block: CreateKxDatabaseRequest.Builder.() -> Unit): CreateKxDatabaseResponse = createKxDatabase(CreateKxDatabaseRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on kdb clusters. Dataviews are only available for clusters running on a scaling group. They are not supported on dedicated clusters.
 */
public suspend inline fun FinspaceClient.createKxDataview(crossinline block: CreateKxDataviewRequest.Builder.() -> Unit): CreateKxDataviewResponse = createKxDataview(CreateKxDataviewRequest.Builder().apply(block).build())

/**
 * Creates a managed kdb environment for the account.
 */
public suspend inline fun FinspaceClient.createKxEnvironment(crossinline block: CreateKxEnvironmentRequest.Builder.() -> Unit): CreateKxEnvironmentResponse = createKxEnvironment(CreateKxEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates a new scaling group.
 */
public suspend inline fun FinspaceClient.createKxScalingGroup(crossinline block: CreateKxScalingGroupRequest.Builder.() -> Unit): CreateKxScalingGroupResponse = createKxScalingGroup(CreateKxScalingGroupRequest.Builder().apply(block).build())

/**
 * Creates a user in FinSpace kdb environment with an associated IAM role.
 */
public suspend inline fun FinspaceClient.createKxUser(crossinline block: CreateKxUserRequest.Builder.() -> Unit): CreateKxUserResponse = createKxUser(CreateKxUserRequest.Builder().apply(block).build())

/**
 * Creates a new volume with a specific amount of throughput and storage capacity.
 */
public suspend inline fun FinspaceClient.createKxVolume(crossinline block: CreateKxVolumeRequest.Builder.() -> Unit): CreateKxVolumeResponse = createKxVolume(CreateKxVolumeRequest.Builder().apply(block).build())

/**
 * Delete an FinSpace environment.
 */
@Deprecated("This method will be discontinued.")
public suspend inline fun FinspaceClient.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes a kdb cluster.
 */
public suspend inline fun FinspaceClient.deleteKxCluster(crossinline block: DeleteKxClusterRequest.Builder.() -> Unit): DeleteKxClusterResponse = deleteKxCluster(DeleteKxClusterRequest.Builder().apply(block).build())

/**
 * Deletes the specified nodes from a cluster.
 */
public suspend inline fun FinspaceClient.deleteKxClusterNode(crossinline block: DeleteKxClusterNodeRequest.Builder.() -> Unit): DeleteKxClusterNodeResponse = deleteKxClusterNode(DeleteKxClusterNodeRequest.Builder().apply(block).build())

/**
 * Deletes the specified database and all of its associated data. This action is irreversible. You must copy any data out of the database before deleting it if the data is to be retained.
 */
public suspend inline fun FinspaceClient.deleteKxDatabase(crossinline block: DeleteKxDatabaseRequest.Builder.() -> Unit): DeleteKxDatabaseResponse = deleteKxDatabase(DeleteKxDatabaseRequest.Builder().apply(block).build())

/**
 * Deletes the specified dataview. Before deleting a dataview, make sure that it is not in use by any cluster.
 */
public suspend inline fun FinspaceClient.deleteKxDataview(crossinline block: DeleteKxDataviewRequest.Builder.() -> Unit): DeleteKxDataviewResponse = deleteKxDataview(DeleteKxDataviewRequest.Builder().apply(block).build())

/**
 * Deletes the kdb environment. This action is irreversible. Deleting a kdb environment will remove all the associated data and any services running in it.
 */
public suspend inline fun FinspaceClient.deleteKxEnvironment(crossinline block: DeleteKxEnvironmentRequest.Builder.() -> Unit): DeleteKxEnvironmentResponse = deleteKxEnvironment(DeleteKxEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes the specified scaling group. This action is irreversible. You cannot delete a scaling group until all the clusters running on it have been deleted.
 */
public suspend inline fun FinspaceClient.deleteKxScalingGroup(crossinline block: DeleteKxScalingGroupRequest.Builder.() -> Unit): DeleteKxScalingGroupResponse = deleteKxScalingGroup(DeleteKxScalingGroupRequest.Builder().apply(block).build())

/**
 * Deletes a user in the specified kdb environment.
 */
public suspend inline fun FinspaceClient.deleteKxUser(crossinline block: DeleteKxUserRequest.Builder.() -> Unit): DeleteKxUserResponse = deleteKxUser(DeleteKxUserRequest.Builder().apply(block).build())

/**
 * Deletes a volume. You can only delete a volume if it's not attached to a cluster or a dataview. When a volume is deleted, any data on the volume is lost. This action is irreversible.
 */
public suspend inline fun FinspaceClient.deleteKxVolume(crossinline block: DeleteKxVolumeRequest.Builder.() -> Unit): DeleteKxVolumeResponse = deleteKxVolume(DeleteKxVolumeRequest.Builder().apply(block).build())

/**
 * Returns the FinSpace environment object.
 */
@Deprecated("This method will be discontinued.")
public suspend inline fun FinspaceClient.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * Returns information about a kdb changeset.
 */
public suspend inline fun FinspaceClient.getKxChangeset(crossinline block: GetKxChangesetRequest.Builder.() -> Unit): GetKxChangesetResponse = getKxChangeset(GetKxChangesetRequest.Builder().apply(block).build())

/**
 * Retrieves information about a kdb cluster.
 */
public suspend inline fun FinspaceClient.getKxCluster(crossinline block: GetKxClusterRequest.Builder.() -> Unit): GetKxClusterResponse = getKxCluster(GetKxClusterRequest.Builder().apply(block).build())

/**
 * Retrieves a connection string for a user to connect to a kdb cluster. You must call this API using the same role that you have defined while creating a user.
 */
public suspend inline fun FinspaceClient.getKxConnectionString(crossinline block: GetKxConnectionStringRequest.Builder.() -> Unit): GetKxConnectionStringResponse = getKxConnectionString(GetKxConnectionStringRequest.Builder().apply(block).build())

/**
 * Returns database information for the specified environment ID.
 */
public suspend inline fun FinspaceClient.getKxDatabase(crossinline block: GetKxDatabaseRequest.Builder.() -> Unit): GetKxDatabaseResponse = getKxDatabase(GetKxDatabaseRequest.Builder().apply(block).build())

/**
 * Retrieves details of the dataview.
 */
public suspend inline fun FinspaceClient.getKxDataview(crossinline block: GetKxDataviewRequest.Builder.() -> Unit): GetKxDataviewResponse = getKxDataview(GetKxDataviewRequest.Builder().apply(block).build())

/**
 * Retrieves all the information for the specified kdb environment.
 */
public suspend inline fun FinspaceClient.getKxEnvironment(crossinline block: GetKxEnvironmentRequest.Builder.() -> Unit): GetKxEnvironmentResponse = getKxEnvironment(GetKxEnvironmentRequest.Builder().apply(block).build())

/**
 * Retrieves details of a scaling group.
 */
public suspend inline fun FinspaceClient.getKxScalingGroup(crossinline block: GetKxScalingGroupRequest.Builder.() -> Unit): GetKxScalingGroupResponse = getKxScalingGroup(GetKxScalingGroupRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified kdb user.
 */
public suspend inline fun FinspaceClient.getKxUser(crossinline block: GetKxUserRequest.Builder.() -> Unit): GetKxUserResponse = getKxUser(GetKxUserRequest.Builder().apply(block).build())

/**
 * Retrieves the information about the volume.
 */
public suspend inline fun FinspaceClient.getKxVolume(crossinline block: GetKxVolumeRequest.Builder.() -> Unit): GetKxVolumeResponse = getKxVolume(GetKxVolumeRequest.Builder().apply(block).build())

/**
 * A list of all of your FinSpace environments.
 */
@Deprecated("This method will be discontinued.")
public suspend inline fun FinspaceClient.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the changesets for a database.
 */
public suspend inline fun FinspaceClient.listKxChangesets(crossinline block: ListKxChangesetsRequest.Builder.() -> Unit): ListKxChangesetsResponse = listKxChangesets(ListKxChangesetsRequest.Builder().apply(block).build())

/**
 * Lists all the nodes in a kdb cluster.
 */
public suspend inline fun FinspaceClient.listKxClusterNodes(crossinline block: ListKxClusterNodesRequest.Builder.() -> Unit): ListKxClusterNodesResponse = listKxClusterNodes(ListKxClusterNodesRequest.Builder().apply(block).build())

/**
 * Returns a list of clusters.
 */
public suspend inline fun FinspaceClient.listKxClusters(crossinline block: ListKxClustersRequest.Builder.() -> Unit): ListKxClustersResponse = listKxClusters(ListKxClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of all the databases in the kdb environment.
 */
public suspend inline fun FinspaceClient.listKxDatabases(crossinline block: ListKxDatabasesRequest.Builder.() -> Unit): ListKxDatabasesResponse = listKxDatabases(ListKxDatabasesRequest.Builder().apply(block).build())

/**
 * Returns a list of all the dataviews in the database.
 */
public suspend inline fun FinspaceClient.listKxDataviews(crossinline block: ListKxDataviewsRequest.Builder.() -> Unit): ListKxDataviewsResponse = listKxDataviews(ListKxDataviewsRequest.Builder().apply(block).build())

/**
 * Returns a list of kdb environments created in an account.
 */
public suspend inline fun FinspaceClient.listKxEnvironments(crossinline block: ListKxEnvironmentsRequest.Builder.() -> Unit): ListKxEnvironmentsResponse = listKxEnvironments(ListKxEnvironmentsRequest.Builder().apply(block).build())

/**
 * Returns a list of scaling groups in a kdb environment.
 */
public suspend inline fun FinspaceClient.listKxScalingGroups(crossinline block: ListKxScalingGroupsRequest.Builder.() -> Unit): ListKxScalingGroupsResponse = listKxScalingGroups(ListKxScalingGroupsRequest.Builder().apply(block).build())

/**
 * Lists all the users in a kdb environment.
 */
public suspend inline fun FinspaceClient.listKxUsers(crossinline block: ListKxUsersRequest.Builder.() -> Unit): ListKxUsersResponse = listKxUsers(ListKxUsersRequest.Builder().apply(block).build())

/**
 * Lists all the volumes in a kdb environment.
 */
public suspend inline fun FinspaceClient.listKxVolumes(crossinline block: ListKxVolumesRequest.Builder.() -> Unit): ListKxVolumesResponse = listKxVolumes(ListKxVolumesRequest.Builder().apply(block).build())

/**
 * A list of all tags for a resource.
 */
public suspend inline fun FinspaceClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds metadata tags to a FinSpace resource.
 */
public suspend inline fun FinspaceClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes metadata tags from a FinSpace resource.
 */
public suspend inline fun FinspaceClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update your FinSpace environment.
 */
@Deprecated("This method will be discontinued.")
public suspend inline fun FinspaceClient.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

/**
 * Allows you to update code configuration on a running cluster. By using this API you can update the code, the initialization script path, and the command line arguments for a specific cluster. The configuration that you want to update will override any existing configurations on the cluster.
 */
public suspend inline fun FinspaceClient.updateKxClusterCodeConfiguration(crossinline block: UpdateKxClusterCodeConfigurationRequest.Builder.() -> Unit): UpdateKxClusterCodeConfigurationResponse = updateKxClusterCodeConfiguration(UpdateKxClusterCodeConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the databases mounted on a kdb cluster, which includes the `changesetId` and all the dbPaths to be cached. This API does not allow you to change a database name or add a database if you created a cluster without one.
 *
 * Using this API you can point a cluster to a different changeset and modify a list of partitions being cached.
 */
public suspend inline fun FinspaceClient.updateKxClusterDatabases(crossinline block: UpdateKxClusterDatabasesRequest.Builder.() -> Unit): UpdateKxClusterDatabasesResponse = updateKxClusterDatabases(UpdateKxClusterDatabasesRequest.Builder().apply(block).build())

/**
 * Updates information for the given kdb database.
 */
public suspend inline fun FinspaceClient.updateKxDatabase(crossinline block: UpdateKxDatabaseRequest.Builder.() -> Unit): UpdateKxDatabaseResponse = updateKxDatabase(UpdateKxDatabaseRequest.Builder().apply(block).build())

/**
 * Updates the specified dataview. The dataviews get automatically updated when any new changesets are ingested. Each update of the dataview creates a new version, including changeset details and cache configurations
 */
public suspend inline fun FinspaceClient.updateKxDataview(crossinline block: UpdateKxDataviewRequest.Builder.() -> Unit): UpdateKxDataviewResponse = updateKxDataview(UpdateKxDataviewRequest.Builder().apply(block).build())

/**
 * Updates information for the given kdb environment.
 */
public suspend inline fun FinspaceClient.updateKxEnvironment(crossinline block: UpdateKxEnvironmentRequest.Builder.() -> Unit): UpdateKxEnvironmentResponse = updateKxEnvironment(UpdateKxEnvironmentRequest.Builder().apply(block).build())

/**
 * Updates environment network to connect to your internal network by using a transit gateway. This API supports request to create a transit gateway attachment from FinSpace VPC to your transit gateway ID and create a custom Route-53 outbound resolvers.
 *
 * Once you send a request to update a network, you cannot change it again. Network update might require termination of any clusters that are running in the existing network.
 */
public suspend inline fun FinspaceClient.updateKxEnvironmentNetwork(crossinline block: UpdateKxEnvironmentNetworkRequest.Builder.() -> Unit): UpdateKxEnvironmentNetworkResponse = updateKxEnvironmentNetwork(UpdateKxEnvironmentNetworkRequest.Builder().apply(block).build())

/**
 * Updates the user details. You can only update the IAM role associated with a user.
 */
public suspend inline fun FinspaceClient.updateKxUser(crossinline block: UpdateKxUserRequest.Builder.() -> Unit): UpdateKxUserResponse = updateKxUser(UpdateKxUserRequest.Builder().apply(block).build())

/**
 * Updates the throughput or capacity of a volume. During the update process, the filesystem might be unavailable for a few minutes. You can retry any operations after the update is complete.
 */
public suspend inline fun FinspaceClient.updateKxVolume(crossinline block: UpdateKxVolumeRequest.Builder.() -> Unit): UpdateKxVolumeResponse = updateKxVolume(UpdateKxVolumeRequest.Builder().apply(block).build())
