// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.CustomDnsServer
import aws.sdk.kotlin.services.finspace.model.DnsStatus
import aws.sdk.kotlin.services.finspace.model.EnvironmentStatus
import aws.sdk.kotlin.services.finspace.model.FinspaceException
import aws.sdk.kotlin.services.finspace.model.TgwStatus
import aws.sdk.kotlin.services.finspace.model.TransitGatewayConfiguration
import aws.sdk.kotlin.services.finspace.model.UpdateKxEnvironmentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class UpdateKxEnvironmentOperationDeserializer: HttpDeserialize<UpdateKxEnvironmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateKxEnvironmentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateKxEnvironmentError(context, call)
        }
        val builder = UpdateKxEnvironmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateKxEnvironmentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateKxEnvironmentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FinspaceException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> FinspaceException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateKxEnvironmentOperationBody(builder: UpdateKxEnvironmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABILITYZONEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("availabilityZoneIds"))
    val AWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsAccountId"))
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTimestamp"))
    val CUSTOMDNSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("customDNSConfiguration"))
    val DEDICATEDSERVICEACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dedicatedServiceAccountId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DNSSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dnsStatus"))
    val ENVIRONMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentArn"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentId"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TGWSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("tgwStatus"))
    val TRANSITGATEWAYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("transitGatewayConfiguration"))
    val UPDATETIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONEIDS_DESCRIPTOR)
        field(AWSACCOUNTID_DESCRIPTOR)
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(CUSTOMDNSCONFIGURATION_DESCRIPTOR)
        field(DEDICATEDSERVICEACCOUNTID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DNSSTATUS_DESCRIPTOR)
        field(ENVIRONMENTARN_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TGWSTATUS_DESCRIPTOR)
        field(TRANSITGATEWAYCONFIGURATION_DESCRIPTOR)
        field(UPDATETIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABILITYZONEIDS_DESCRIPTOR.index -> builder.availabilityZoneIds =
                    deserializer.deserializeList(AVAILABILITYZONEIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AWSACCOUNTID_DESCRIPTOR.index -> builder.awsAccountId = deserializeString()
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                CUSTOMDNSCONFIGURATION_DESCRIPTOR.index -> builder.customDnsConfiguration =
                    deserializer.deserializeList(CUSTOMDNSCONFIGURATION_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomDnsServer>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomDnsServerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DEDICATEDSERVICEACCOUNTID_DESCRIPTOR.index -> builder.dedicatedServiceAccountId = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DNSSTATUS_DESCRIPTOR.index -> builder.dnsStatus = deserializeString().let { DnsStatus.fromValue(it) }
                ENVIRONMENTARN_DESCRIPTOR.index -> builder.environmentArn = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EnvironmentStatus.fromValue(it) }
                TGWSTATUS_DESCRIPTOR.index -> builder.tgwStatus = deserializeString().let { TgwStatus.fromValue(it) }
                TRANSITGATEWAYCONFIGURATION_DESCRIPTOR.index -> builder.transitGatewayConfiguration = deserializeTransitGatewayConfigurationDocument(deserializer)
                UPDATETIMESTAMP_DESCRIPTOR.index -> builder.updateTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
