// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.KxDataviewSegmentConfiguration
import aws.sdk.kotlin.services.finspace.model.UpdateKxDataviewRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateKxDataviewOperationSerializer: HttpSerialize<UpdateKxDataviewRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateKxDataviewRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.environmentId) { "environmentId is bound to the URI and must not be null" }
            requireNotNull(input.databaseName) { "databaseName is bound to the URI and must not be null" }
            requireNotNull(input.dataviewName) { "dataviewName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("kx"))
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode("${input.environmentId}"))
                add(PercentEncoding.Path.encode("databases"))
                add(PercentEncoding.SmithyLabel.encode("${input.databaseName}"))
                add(PercentEncoding.Path.encode("dataviews"))
                add(PercentEncoding.SmithyLabel.encode("${input.dataviewName}"))
            }
        }

        val payload = serializeUpdateKxDataviewOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateKxDataviewOperationBody(context: ExecutionContext, input: UpdateKxDataviewRequest): ByteArray {
    val serializer = JsonSerializer()
    val CHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("changesetId"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val SEGMENTCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("segmentConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANGESETID_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(SEGMENTCONFIGURATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.changesetId?.let { field(CHANGESETID_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.segmentConfigurations != null) {
            listField(SEGMENTCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.segmentConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeKxDataviewSegmentConfigurationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
