// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.FinspaceException
import aws.sdk.kotlin.services.finspace.model.KxAzMode
import aws.sdk.kotlin.services.finspace.model.KxDataviewActiveVersion
import aws.sdk.kotlin.services.finspace.model.KxDataviewSegmentConfiguration
import aws.sdk.kotlin.services.finspace.model.KxDataviewStatus
import aws.sdk.kotlin.services.finspace.model.UpdateKxDataviewResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class UpdateKxDataviewOperationDeserializer: HttpDeserialize<UpdateKxDataviewResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateKxDataviewResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateKxDataviewError(context, call)
        }
        val builder = UpdateKxDataviewResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateKxDataviewOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateKxDataviewError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FinspaceException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> FinspaceException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateKxDataviewOperationBody(builder: UpdateKxDataviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVEVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("activeVersions"))
    val AUTOUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoUpdate"))
    val AVAILABILITYZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("availabilityZoneId"))
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("azMode"))
    val CHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("changesetId"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdTimestamp"))
    val DATABASENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("databaseName"))
    val DATAVIEWNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataviewName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentId"))
    val LASTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTimestamp"))
    val SEGMENTCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("segmentConfigurations"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVEVERSIONS_DESCRIPTOR)
        field(AUTOUPDATE_DESCRIPTOR)
        field(AVAILABILITYZONEID_DESCRIPTOR)
        field(AZMODE_DESCRIPTOR)
        field(CHANGESETID_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DATABASENAME_DESCRIPTOR)
        field(DATAVIEWNAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(LASTMODIFIEDTIMESTAMP_DESCRIPTOR)
        field(SEGMENTCONFIGURATIONS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVEVERSIONS_DESCRIPTOR.index -> builder.activeVersions =
                    deserializer.deserializeList(ACTIVEVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<KxDataviewActiveVersion>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeKxDataviewActiveVersionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTOUPDATE_DESCRIPTOR.index -> builder.autoUpdate = deserializeBoolean()
                AVAILABILITYZONEID_DESCRIPTOR.index -> builder.availabilityZoneId = deserializeString()
                AZMODE_DESCRIPTOR.index -> builder.azMode = deserializeString().let { KxAzMode.fromValue(it) }
                CHANGESETID_DESCRIPTOR.index -> builder.changesetId = deserializeString()
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATABASENAME_DESCRIPTOR.index -> builder.databaseName = deserializeString()
                DATAVIEWNAME_DESCRIPTOR.index -> builder.dataviewName = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                LASTMODIFIEDTIMESTAMP_DESCRIPTOR.index -> builder.lastModifiedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                SEGMENTCONFIGURATIONS_DESCRIPTOR.index -> builder.segmentConfigurations =
                    deserializer.deserializeList(SEGMENTCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<KxDataviewSegmentConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeKxDataviewSegmentConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { KxDataviewStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
