// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.AutoScalingConfiguration
import aws.sdk.kotlin.services.finspace.model.CapacityConfiguration
import aws.sdk.kotlin.services.finspace.model.CodeConfiguration
import aws.sdk.kotlin.services.finspace.model.FinspaceException
import aws.sdk.kotlin.services.finspace.model.GetKxClusterResponse
import aws.sdk.kotlin.services.finspace.model.KxAzMode
import aws.sdk.kotlin.services.finspace.model.KxCacheStorageConfiguration
import aws.sdk.kotlin.services.finspace.model.KxClusterStatus
import aws.sdk.kotlin.services.finspace.model.KxClusterType
import aws.sdk.kotlin.services.finspace.model.KxCommandLineArgument
import aws.sdk.kotlin.services.finspace.model.KxDatabaseConfiguration
import aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration
import aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration
import aws.sdk.kotlin.services.finspace.model.TickerplantLogConfiguration
import aws.sdk.kotlin.services.finspace.model.Volume
import aws.sdk.kotlin.services.finspace.model.VpcConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetKxClusterOperationDeserializer: HttpDeserialize<GetKxClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetKxClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetKxClusterError(context, call)
        }
        val builder = GetKxClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetKxClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetKxClusterError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FinspaceException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> FinspaceException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetKxClusterOperationBody(builder: GetKxClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOSCALINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("autoScalingConfiguration"))
    val AVAILABILITYZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("availabilityZoneId"))
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("azMode"))
    val CACHESTORAGECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cacheStorageConfigurations"))
    val CAPACITYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("capacityConfiguration"))
    val CLUSTERDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterDescription"))
    val CLUSTERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterName"))
    val CLUSTERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("clusterType"))
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("code"))
    val COMMANDLINEARGUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("commandLineArguments"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdTimestamp"))
    val DATABASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("databases"))
    val EXECUTIONROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionRole"))
    val INITIALIZATIONSCRIPT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("initializationScript"))
    val LASTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTimestamp"))
    val RELEASELABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("releaseLabel"))
    val SAVEDOWNSTORAGECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("savedownStorageConfiguration"))
    val SCALINGGROUPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scalingGroupConfiguration"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val TICKERPLANTLOGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tickerplantLogConfiguration"))
    val VOLUMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("volumes"))
    val VPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOSCALINGCONFIGURATION_DESCRIPTOR)
        field(AVAILABILITYZONEID_DESCRIPTOR)
        field(AZMODE_DESCRIPTOR)
        field(CACHESTORAGECONFIGURATIONS_DESCRIPTOR)
        field(CAPACITYCONFIGURATION_DESCRIPTOR)
        field(CLUSTERDESCRIPTION_DESCRIPTOR)
        field(CLUSTERNAME_DESCRIPTOR)
        field(CLUSTERTYPE_DESCRIPTOR)
        field(CODE_DESCRIPTOR)
        field(COMMANDLINEARGUMENTS_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DATABASES_DESCRIPTOR)
        field(EXECUTIONROLE_DESCRIPTOR)
        field(INITIALIZATIONSCRIPT_DESCRIPTOR)
        field(LASTMODIFIEDTIMESTAMP_DESCRIPTOR)
        field(RELEASELABEL_DESCRIPTOR)
        field(SAVEDOWNSTORAGECONFIGURATION_DESCRIPTOR)
        field(SCALINGGROUPCONFIGURATION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(TICKERPLANTLOGCONFIGURATION_DESCRIPTOR)
        field(VOLUMES_DESCRIPTOR)
        field(VPCCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOSCALINGCONFIGURATION_DESCRIPTOR.index -> builder.autoScalingConfiguration = deserializeAutoScalingConfigurationDocument(deserializer)
                AVAILABILITYZONEID_DESCRIPTOR.index -> builder.availabilityZoneId = deserializeString()
                AZMODE_DESCRIPTOR.index -> builder.azMode = deserializeString().let { KxAzMode.fromValue(it) }
                CACHESTORAGECONFIGURATIONS_DESCRIPTOR.index -> builder.cacheStorageConfigurations =
                    deserializer.deserializeList(CACHESTORAGECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<KxCacheStorageConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeKxCacheStorageConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CAPACITYCONFIGURATION_DESCRIPTOR.index -> builder.capacityConfiguration = deserializeCapacityConfigurationDocument(deserializer)
                CLUSTERDESCRIPTION_DESCRIPTOR.index -> builder.clusterDescription = deserializeString()
                CLUSTERNAME_DESCRIPTOR.index -> builder.clusterName = deserializeString()
                CLUSTERTYPE_DESCRIPTOR.index -> builder.clusterType = deserializeString().let { KxClusterType.fromValue(it) }
                CODE_DESCRIPTOR.index -> builder.code = deserializeCodeConfigurationDocument(deserializer)
                COMMANDLINEARGUMENTS_DESCRIPTOR.index -> builder.commandLineArguments =
                    deserializer.deserializeList(COMMANDLINEARGUMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<KxCommandLineArgument>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeKxCommandLineArgumentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATABASES_DESCRIPTOR.index -> builder.databases =
                    deserializer.deserializeList(DATABASES_DESCRIPTOR) {
                        val col0 = mutableListOf<KxDatabaseConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeKxDatabaseConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EXECUTIONROLE_DESCRIPTOR.index -> builder.executionRole = deserializeString()
                INITIALIZATIONSCRIPT_DESCRIPTOR.index -> builder.initializationScript = deserializeString()
                LASTMODIFIEDTIMESTAMP_DESCRIPTOR.index -> builder.lastModifiedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                RELEASELABEL_DESCRIPTOR.index -> builder.releaseLabel = deserializeString()
                SAVEDOWNSTORAGECONFIGURATION_DESCRIPTOR.index -> builder.savedownStorageConfiguration = deserializeKxSavedownStorageConfigurationDocument(deserializer)
                SCALINGGROUPCONFIGURATION_DESCRIPTOR.index -> builder.scalingGroupConfiguration = deserializeKxScalingGroupConfigurationDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { KxClusterStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                TICKERPLANTLOGCONFIGURATION_DESCRIPTOR.index -> builder.tickerplantLogConfiguration = deserializeTickerplantLogConfigurationDocument(deserializer)
                VOLUMES_DESCRIPTOR.index -> builder.volumes =
                    deserializer.deserializeList(VOLUMES_DESCRIPTOR) {
                        val col0 = mutableListOf<Volume>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVolumeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCCONFIGURATION_DESCRIPTOR.index -> builder.vpcConfiguration = deserializeVpcConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
