// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.ChangeRequest
import aws.sdk.kotlin.services.finspace.model.ChangesetStatus
import aws.sdk.kotlin.services.finspace.model.ErrorInfo
import aws.sdk.kotlin.services.finspace.model.FinspaceException
import aws.sdk.kotlin.services.finspace.model.GetKxChangesetResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetKxChangesetOperationDeserializer: HttpDeserialize<GetKxChangesetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetKxChangesetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetKxChangesetError(context, call)
        }
        val builder = GetKxChangesetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetKxChangesetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetKxChangesetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FinspaceException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> FinspaceException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetKxChangesetOperationBody(builder: GetKxChangesetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVEFROMTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("activeFromTimestamp"))
    val CHANGEREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("changeRequests"))
    val CHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("changesetId"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdTimestamp"))
    val DATABASENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("databaseName"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentId"))
    val ERRORINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("errorInfo"))
    val LASTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTimestamp"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVEFROMTIMESTAMP_DESCRIPTOR)
        field(CHANGEREQUESTS_DESCRIPTOR)
        field(CHANGESETID_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DATABASENAME_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(ERRORINFO_DESCRIPTOR)
        field(LASTMODIFIEDTIMESTAMP_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVEFROMTIMESTAMP_DESCRIPTOR.index -> builder.activeFromTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                CHANGEREQUESTS_DESCRIPTOR.index -> builder.changeRequests =
                    deserializer.deserializeList(CHANGEREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ChangeRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChangeRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CHANGESETID_DESCRIPTOR.index -> builder.changesetId = deserializeString()
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATABASENAME_DESCRIPTOR.index -> builder.databaseName = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                ERRORINFO_DESCRIPTOR.index -> builder.errorInfo = deserializeErrorInfoDocument(deserializer)
                LASTMODIFIEDTIMESTAMP_DESCRIPTOR.index -> builder.lastModifiedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ChangesetStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
