// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.CreateKxVolumeRequest
import aws.sdk.kotlin.services.finspace.model.KxAzMode
import aws.sdk.kotlin.services.finspace.model.KxNas1Configuration
import aws.sdk.kotlin.services.finspace.model.KxVolumeType
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateKxVolumeOperationSerializer: HttpSerialize<CreateKxVolumeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateKxVolumeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.environmentId) { "environmentId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("kx"))
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode("${input.environmentId}"))
                add(PercentEncoding.Path.encode("kxvolumes"))
            }
        }

        val payload = serializeCreateKxVolumeOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateKxVolumeOperationBody(context: ExecutionContext, input: CreateKxVolumeRequest): ByteArray {
    val serializer = JsonSerializer()
    val AVAILABILITYZONEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("availabilityZoneIds"))
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("azMode"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val NAS1CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("nas1Configuration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VOLUMENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("volumeName"))
    val VOLUMETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("volumeType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONEIDS_DESCRIPTOR)
        field(AZMODE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAS1CONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VOLUMENAME_DESCRIPTOR)
        field(VOLUMETYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.availabilityZoneIds != null) {
            listField(AVAILABILITYZONEIDS_DESCRIPTOR) {
                for (el0 in input.availabilityZoneIds) {
                    serializeString(el0)
                }
            }
        }
        input.azMode?.let { field(AZMODE_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.nas1Configuration?.let { field(NAS1CONFIGURATION_DESCRIPTOR, it, ::serializeKxNas1ConfigurationDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.volumeName?.let { field(VOLUMENAME_DESCRIPTOR, it) }
        input.volumeType?.let { field(VOLUMETYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
