// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.CreateKxDataviewRequest
import aws.sdk.kotlin.services.finspace.model.KxAzMode
import aws.sdk.kotlin.services.finspace.model.KxDataviewSegmentConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateKxDataviewOperationSerializer: HttpSerialize<CreateKxDataviewRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateKxDataviewRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.environmentId) { "environmentId is bound to the URI and must not be null" }
            requireNotNull(input.databaseName) { "databaseName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("kx"))
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode("${input.environmentId}"))
                add(PercentEncoding.Path.encode("databases"))
                add(PercentEncoding.SmithyLabel.encode("${input.databaseName}"))
                add(PercentEncoding.Path.encode("dataviews"))
            }
        }

        val payload = serializeCreateKxDataviewOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateKxDataviewOperationBody(context: ExecutionContext, input: CreateKxDataviewRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTOUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoUpdate"))
    val AVAILABILITYZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("availabilityZoneId"))
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("azMode"))
    val CHANGESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("changesetId"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DATAVIEWNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataviewName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val SEGMENTCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("segmentConfigurations"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOUPDATE_DESCRIPTOR)
        field(AVAILABILITYZONEID_DESCRIPTOR)
        field(AZMODE_DESCRIPTOR)
        field(CHANGESETID_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DATAVIEWNAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(SEGMENTCONFIGURATIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.autoUpdate?.let { field(AUTOUPDATE_DESCRIPTOR, it) }
        input.availabilityZoneId?.let { field(AVAILABILITYZONEID_DESCRIPTOR, it) }
        input.azMode?.let { field(AZMODE_DESCRIPTOR, it.value) }
        input.changesetId?.let { field(CHANGESETID_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.dataviewName?.let { field(DATAVIEWNAME_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.segmentConfigurations != null) {
            listField(SEGMENTCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.segmentConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeKxDataviewSegmentConfigurationDocument))
                }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
