// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.paginators

import aws.sdk.kotlin.services.finspace.FinspaceClient
import aws.sdk.kotlin.services.finspace.model.KxEnvironment
import aws.sdk.kotlin.services.finspace.model.ListKxChangesetsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxChangesetsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxClusterNodesRequest
import aws.sdk.kotlin.services.finspace.model.ListKxClusterNodesResponse
import aws.sdk.kotlin.services.finspace.model.ListKxDatabasesRequest
import aws.sdk.kotlin.services.finspace.model.ListKxDatabasesResponse
import aws.sdk.kotlin.services.finspace.model.ListKxDataviewsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxDataviewsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxEnvironmentsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxEnvironmentsResponse
import aws.sdk.kotlin.services.finspace.model.ListKxScalingGroupsRequest
import aws.sdk.kotlin.services.finspace.model.ListKxScalingGroupsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListKxChangesetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKxChangesetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxChangesetsResponse]
 */
public fun FinspaceClient.listKxChangesetsPaginated(initialRequest: ListKxChangesetsRequest): Flow<ListKxChangesetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKxChangesetsPaginated.listKxChangesets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKxChangesetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxChangesetsResponse]
 */
public fun FinspaceClient.listKxChangesetsPaginated(block: ListKxChangesetsRequest.Builder.() -> Unit): Flow<ListKxChangesetsResponse> =
    listKxChangesetsPaginated(ListKxChangesetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListKxClusterNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKxClusterNodesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxClusterNodesResponse]
 */
public fun FinspaceClient.listKxClusterNodesPaginated(initialRequest: ListKxClusterNodesRequest): Flow<ListKxClusterNodesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKxClusterNodesPaginated.listKxClusterNodes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKxClusterNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxClusterNodesResponse]
 */
public fun FinspaceClient.listKxClusterNodesPaginated(block: ListKxClusterNodesRequest.Builder.() -> Unit): Flow<ListKxClusterNodesResponse> =
    listKxClusterNodesPaginated(ListKxClusterNodesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListKxDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKxDatabasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxDatabasesResponse]
 */
public fun FinspaceClient.listKxDatabasesPaginated(initialRequest: ListKxDatabasesRequest): Flow<ListKxDatabasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKxDatabasesPaginated.listKxDatabases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKxDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxDatabasesResponse]
 */
public fun FinspaceClient.listKxDatabasesPaginated(block: ListKxDatabasesRequest.Builder.() -> Unit): Flow<ListKxDatabasesResponse> =
    listKxDatabasesPaginated(ListKxDatabasesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListKxDataviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKxDataviewsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxDataviewsResponse]
 */
public fun FinspaceClient.listKxDataviewsPaginated(initialRequest: ListKxDataviewsRequest): Flow<ListKxDataviewsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKxDataviewsPaginated.listKxDataviews(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKxDataviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxDataviewsResponse]
 */
public fun FinspaceClient.listKxDataviewsPaginated(block: ListKxDataviewsRequest.Builder.() -> Unit): Flow<ListKxDataviewsResponse> =
    listKxDataviewsPaginated(ListKxDataviewsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListKxEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKxEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxEnvironmentsResponse]
 */
public fun FinspaceClient.listKxEnvironmentsPaginated(initialRequest: ListKxEnvironmentsRequest = ListKxEnvironmentsRequest { }): Flow<ListKxEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKxEnvironmentsPaginated.listKxEnvironments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKxEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxEnvironmentsResponse]
 */
public fun FinspaceClient.listKxEnvironmentsPaginated(block: ListKxEnvironmentsRequest.Builder.() -> Unit): Flow<ListKxEnvironmentsResponse> =
    listKxEnvironmentsPaginated(ListKxEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKxEnvironmentsPaginated]
 * to access the nested member [KxEnvironment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [KxEnvironment]
 */
@JvmName("listKxEnvironmentsResponseKxEnvironment")
public fun Flow<ListKxEnvironmentsResponse>.environments(): Flow<KxEnvironment> =
    transform() { response ->
        response.environments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKxScalingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKxScalingGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxScalingGroupsResponse]
 */
public fun FinspaceClient.listKxScalingGroupsPaginated(initialRequest: ListKxScalingGroupsRequest): Flow<ListKxScalingGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKxScalingGroupsPaginated.listKxScalingGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKxScalingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKxScalingGroupsResponse]
 */
public fun FinspaceClient.listKxScalingGroupsPaginated(block: ListKxScalingGroupsRequest.Builder.() -> Unit): Flow<ListKxScalingGroupsResponse> =
    listKxScalingGroupsPaginated(ListKxScalingGroupsRequest.Builder().apply(block).build())
