// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateKxVolumeResponse private constructor(builder: Builder) {
    /**
     * Specifies the clusters that a volume is attached to.
     */
    public val attachedClusters: List<KxAttachedCluster>? = builder.attachedClusters
    /**
     * The identifier of the availability zones.
     */
    public val availabilityZoneIds: List<String>? = builder.availabilityZoneIds
    /**
     * The number of availability zones you want to assign per cluster. Currently, FinSpace only support `SINGLE` for volumes.
     */
    public val azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = builder.azMode
    /**
     * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The description for the volume.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the kdb environment where you want to update the volume.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimestamp
    /**
     * Specifies the configuration for the Network attached storage (NAS_1) file system volume.
     */
    public val nas1Configuration: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration? = builder.nas1Configuration
    /**
     * The status of the volume.
     * + CREATING – The volume creation is in progress.
     * + CREATE_FAILED – The volume creation has failed.
     * + ACTIVE – The volume is active.
     * + UPDATING – The volume is in the process of being updated.
     * + UPDATE_FAILED – The update action failed.
     * + UPDATED – The volume is successfully updated.
     * + DELETING – The volume is in the process of being deleted.
     * + DELETE_FAILED – The system failed to delete the volume.
     * + DELETED – The volume is successfully deleted.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.KxVolumeStatus? = builder.status
    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The ARN identifier of the volume.
     */
    public val volumeArn: kotlin.String? = builder.volumeArn
    /**
     * A unique identifier for the volume that you want to update.
     */
    public val volumeName: kotlin.String? = builder.volumeName
    /**
     * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type.
     */
    public val volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.UpdateKxVolumeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateKxVolumeResponse(")
        append("attachedClusters=$attachedClusters,")
        append("availabilityZoneIds=$availabilityZoneIds,")
        append("azMode=$azMode,")
        append("createdTimestamp=$createdTimestamp,")
        append("description=$description,")
        append("environmentId=$environmentId,")
        append("lastModifiedTimestamp=$lastModifiedTimestamp,")
        append("nas1Configuration=$nas1Configuration,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("volumeArn=$volumeArn,")
        append("volumeName=$volumeName,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachedClusters?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneIds?.hashCode() ?: 0)
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (nas1Configuration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeName?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateKxVolumeResponse

        if (attachedClusters != other.attachedClusters) return false
        if (availabilityZoneIds != other.availabilityZoneIds) return false
        if (azMode != other.azMode) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (description != other.description) return false
        if (environmentId != other.environmentId) return false
        if (lastModifiedTimestamp != other.lastModifiedTimestamp) return false
        if (nas1Configuration != other.nas1Configuration) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeName != other.volumeName) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.UpdateKxVolumeResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the clusters that a volume is attached to.
         */
        public var attachedClusters: List<KxAttachedCluster>? = null
        /**
         * The identifier of the availability zones.
         */
        public var availabilityZoneIds: List<String>? = null
        /**
         * The number of availability zones you want to assign per cluster. Currently, FinSpace only support `SINGLE` for volumes.
         */
        public var azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = null
        /**
         * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the volume.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the kdb environment where you want to update the volume.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the configuration for the Network attached storage (NAS_1) file system volume.
         */
        public var nas1Configuration: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration? = null
        /**
         * The status of the volume.
         * + CREATING – The volume creation is in progress.
         * + CREATE_FAILED – The volume creation has failed.
         * + ACTIVE – The volume is active.
         * + UPDATING – The volume is in the process of being updated.
         * + UPDATE_FAILED – The update action failed.
         * + UPDATED – The volume is successfully updated.
         * + DELETING – The volume is in the process of being deleted.
         * + DELETE_FAILED – The system failed to delete the volume.
         * + DELETED – The volume is successfully deleted.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.KxVolumeStatus? = null
        /**
         * The error message when a failed state occurs.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The ARN identifier of the volume.
         */
        public var volumeArn: kotlin.String? = null
        /**
         * A unique identifier for the volume that you want to update.
         */
        public var volumeName: kotlin.String? = null
        /**
         * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type.
         */
        public var volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.UpdateKxVolumeResponse) : this() {
            this.attachedClusters = x.attachedClusters
            this.availabilityZoneIds = x.availabilityZoneIds
            this.azMode = x.azMode
            this.createdTimestamp = x.createdTimestamp
            this.description = x.description
            this.environmentId = x.environmentId
            this.lastModifiedTimestamp = x.lastModifiedTimestamp
            this.nas1Configuration = x.nas1Configuration
            this.status = x.status
            this.statusReason = x.statusReason
            this.volumeArn = x.volumeArn
            this.volumeName = x.volumeName
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.UpdateKxVolumeResponse = UpdateKxVolumeResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.KxNas1Configuration] inside the given [block]
         */
        public fun nas1Configuration(block: aws.sdk.kotlin.services.finspace.model.KxNas1Configuration.Builder.() -> kotlin.Unit) {
            this.nas1Configuration = aws.sdk.kotlin.services.finspace.model.KxNas1Configuration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
