// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model



/**
 * The structure of the transit gateway and network configuration that is used to connect the kdb environment to an internal network.
 */
public class TransitGatewayConfiguration private constructor(builder: Builder) {
    /**
     * The rules that define how you manage the outbound traffic from kdb network to your internal network.
     */
    public val attachmentNetworkAclConfiguration: List<NetworkAclEntry>? = builder.attachmentNetworkAclConfiguration
    /**
     * The routing CIDR on behalf of kdb environment. It could be any "/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer's transit gateway routing table so that the traffics could be routed to kdb network.
     */
    public val routableCidrSpace: kotlin.String = requireNotNull(builder.routableCidrSpace) { "A non-null value must be provided for routableCidrSpace" }
    /**
     * The identifier of the transit gateway created by the customer to connect outbound traffics from kdb network to your internal network.
     */
    public val transitGatewayId: kotlin.String = requireNotNull(builder.transitGatewayId) { "A non-null value must be provided for transitGatewayId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.TransitGatewayConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayConfiguration(")
        append("attachmentNetworkAclConfiguration=$attachmentNetworkAclConfiguration,")
        append("routableCidrSpace=$routableCidrSpace,")
        append("transitGatewayId=$transitGatewayId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentNetworkAclConfiguration?.hashCode() ?: 0
        result = 31 * result + (routableCidrSpace.hashCode())
        result = 31 * result + (transitGatewayId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransitGatewayConfiguration

        if (attachmentNetworkAclConfiguration != other.attachmentNetworkAclConfiguration) return false
        if (routableCidrSpace != other.routableCidrSpace) return false
        if (transitGatewayId != other.transitGatewayId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.TransitGatewayConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The rules that define how you manage the outbound traffic from kdb network to your internal network.
         */
        public var attachmentNetworkAclConfiguration: List<NetworkAclEntry>? = null
        /**
         * The routing CIDR on behalf of kdb environment. It could be any "/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer's transit gateway routing table so that the traffics could be routed to kdb network.
         */
        public var routableCidrSpace: kotlin.String? = null
        /**
         * The identifier of the transit gateway created by the customer to connect outbound traffics from kdb network to your internal network.
         */
        public var transitGatewayId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.TransitGatewayConfiguration) : this() {
            this.attachmentNetworkAclConfiguration = x.attachmentNetworkAclConfiguration
            this.routableCidrSpace = x.routableCidrSpace
            this.transitGatewayId = x.transitGatewayId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.TransitGatewayConfiguration = TransitGatewayConfiguration(this)

        internal fun correctErrors(): Builder {
            if (routableCidrSpace == null) routableCidrSpace = ""
            if (transitGatewayId == null) transitGatewayId = ""
            return this
        }
    }
}
