// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure that contains the metadata of the volume.
 */
public class KxVolume private constructor(builder: Builder) {
    /**
     * The identifier of the availability zones.
     */
    public val availabilityZoneIds: List<String>? = builder.availabilityZoneIds
    /**
     * The number of availability zones assigned to the volume. Currently, only `SINGLE` is supported.
     */
    public val azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = builder.azMode
    /**
     * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * A description of the volume.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimestamp
    /**
     * The status of volume.
     * + CREATING – The volume creation is in progress.
     * + CREATE_FAILED – The volume creation has failed.
     * + ACTIVE – The volume is active.
     * + UPDATING – The volume is in the process of being updated.
     * + UPDATE_FAILED – The update action failed.
     * + UPDATED – The volume is successfully updated.
     * + DELETING – The volume is in the process of being deleted.
     * + DELETE_FAILED – The system failed to delete the volume.
     * + DELETED – The volume is successfully deleted.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.KxVolumeStatus? = builder.status
    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * A unique identifier for the volume.
     */
    public val volumeName: kotlin.String? = builder.volumeName
    /**
     * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type.
     */
    public val volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxVolume = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxVolume(")
        append("availabilityZoneIds=$availabilityZoneIds,")
        append("azMode=$azMode,")
        append("createdTimestamp=$createdTimestamp,")
        append("description=$description,")
        append("lastModifiedTimestamp=$lastModifiedTimestamp,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("volumeName=$volumeName,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneIds?.hashCode() ?: 0
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (volumeName?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxVolume

        if (availabilityZoneIds != other.availabilityZoneIds) return false
        if (azMode != other.azMode) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (description != other.description) return false
        if (lastModifiedTimestamp != other.lastModifiedTimestamp) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (volumeName != other.volumeName) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxVolume = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the availability zones.
         */
        public var availabilityZoneIds: List<String>? = null
        /**
         * The number of availability zones assigned to the volume. Currently, only `SINGLE` is supported.
         */
        public var azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = null
        /**
         * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the volume.
         */
        public var description: kotlin.String? = null
        /**
         * The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of volume.
         * + CREATING – The volume creation is in progress.
         * + CREATE_FAILED – The volume creation has failed.
         * + ACTIVE – The volume is active.
         * + UPDATING – The volume is in the process of being updated.
         * + UPDATE_FAILED – The update action failed.
         * + UPDATED – The volume is successfully updated.
         * + DELETING – The volume is in the process of being deleted.
         * + DELETE_FAILED – The system failed to delete the volume.
         * + DELETED – The volume is successfully deleted.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.KxVolumeStatus? = null
        /**
         * The error message when a failed state occurs.
         */
        public var statusReason: kotlin.String? = null
        /**
         * A unique identifier for the volume.
         */
        public var volumeName: kotlin.String? = null
        /**
         * The type of file system volume. Currently, FinSpace only supports `NAS_1` volume type.
         */
        public var volumeType: aws.sdk.kotlin.services.finspace.model.KxVolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxVolume) : this() {
            this.availabilityZoneIds = x.availabilityZoneIds
            this.azMode = x.azMode
            this.createdTimestamp = x.createdTimestamp
            this.description = x.description
            this.lastModifiedTimestamp = x.lastModifiedTimestamp
            this.status = x.status
            this.statusReason = x.statusReason
            this.volumeName = x.volumeName
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxVolume = KxVolume(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
