// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model



/**
 * The size and type of temporary storage that is used to hold data during the savedown process. All the data written to this storage space is lost when the cluster node is restarted.
 */
public class KxSavedownStorageConfiguration private constructor(builder: Builder) {
    /**
     * The size of temporary storage in gibibytes.
     */
    public val size: kotlin.Int? = builder.size
    /**
     * The type of writeable storage space for temporarily storing your savedown data. The valid values are:
     * + SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
     */
    public val type: aws.sdk.kotlin.services.finspace.model.KxSavedownStorageType? = builder.type
    /**
     * The name of the kdb volume that you want to use as writeable save-down storage for clusters.
     */
    public val volumeName: kotlin.String? = builder.volumeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxSavedownStorageConfiguration(")
        append("size=$size,")
        append("type=$type,")
        append("volumeName=$volumeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = size ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (volumeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxSavedownStorageConfiguration

        if (size != other.size) return false
        if (type != other.type) return false
        if (volumeName != other.volumeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The size of temporary storage in gibibytes.
         */
        public var size: kotlin.Int? = null
        /**
         * The type of writeable storage space for temporarily storing your savedown data. The valid values are:
         * + SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
         */
        public var type: aws.sdk.kotlin.services.finspace.model.KxSavedownStorageType? = null
        /**
         * The name of the kdb volume that you want to use as writeable save-down storage for clusters.
         */
        public var volumeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration) : this() {
            this.size = x.size
            this.type = x.type
            this.volumeName = x.volumeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration = KxSavedownStorageConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
