// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A collection of kdb dataview entries.
 */
public class KxDataviewListEntry private constructor(builder: Builder) {
    /**
     * The active changeset versions for the given dataview entry.
     */
    public val activeVersions: List<KxDataviewActiveVersion>? = builder.activeVersions
    /**
     * The option to specify whether you want to apply all the future additions and corrections automatically to the dataview when you ingest new changesets. The default value is false.
     */
    public val autoUpdate: kotlin.Boolean = builder.autoUpdate
    /**
     * The identifier of the availability zones.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The number of availability zones you want to assign per cluster. This can be one of the following
     * + `SINGLE` – Assigns one availability zone per cluster.
     * + `MULTI` – Assigns all the availability zones per cluster.
     */
    public val azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = builder.azMode
    /**
     * A unique identifier for the changeset.
     */
    public val changesetId: kotlin.String? = builder.changesetId
    /**
     * The timestamp at which the dataview list entry was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * A unique identifier of the database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * A unique identifier of the dataview.
     */
    public val dataviewName: kotlin.String? = builder.dataviewName
    /**
     * A description for the dataview list entry.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the kdb environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The last time that the dataview list was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimestamp
    /**
     * The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment.
     */
    public val segmentConfigurations: List<KxDataviewSegmentConfiguration>? = builder.segmentConfigurations
    /**
     * The status of a given dataview entry.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.KxDataviewStatus? = builder.status
    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxDataviewListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxDataviewListEntry(")
        append("activeVersions=$activeVersions,")
        append("autoUpdate=$autoUpdate,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("azMode=$azMode,")
        append("changesetId=$changesetId,")
        append("createdTimestamp=$createdTimestamp,")
        append("databaseName=$databaseName,")
        append("dataviewName=$dataviewName,")
        append("description=$description,")
        append("environmentId=$environmentId,")
        append("lastModifiedTimestamp=$lastModifiedTimestamp,")
        append("segmentConfigurations=$segmentConfigurations,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeVersions?.hashCode() ?: 0
        result = 31 * result + (autoUpdate.hashCode())
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (changesetId?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dataviewName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (segmentConfigurations?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxDataviewListEntry

        if (activeVersions != other.activeVersions) return false
        if (autoUpdate != other.autoUpdate) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (azMode != other.azMode) return false
        if (changesetId != other.changesetId) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (databaseName != other.databaseName) return false
        if (dataviewName != other.dataviewName) return false
        if (description != other.description) return false
        if (environmentId != other.environmentId) return false
        if (lastModifiedTimestamp != other.lastModifiedTimestamp) return false
        if (segmentConfigurations != other.segmentConfigurations) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxDataviewListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The active changeset versions for the given dataview entry.
         */
        public var activeVersions: List<KxDataviewActiveVersion>? = null
        /**
         * The option to specify whether you want to apply all the future additions and corrections automatically to the dataview when you ingest new changesets. The default value is false.
         */
        public var autoUpdate: kotlin.Boolean = false
        /**
         * The identifier of the availability zones.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * The number of availability zones you want to assign per cluster. This can be one of the following
         * + `SINGLE` – Assigns one availability zone per cluster.
         * + `MULTI` – Assigns all the availability zones per cluster.
         */
        public var azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = null
        /**
         * A unique identifier for the changeset.
         */
        public var changesetId: kotlin.String? = null
        /**
         * The timestamp at which the dataview list entry was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier of the database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * A unique identifier of the dataview.
         */
        public var dataviewName: kotlin.String? = null
        /**
         * A description for the dataview list entry.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the kdb environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The last time that the dataview list was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment.
         */
        public var segmentConfigurations: List<KxDataviewSegmentConfiguration>? = null
        /**
         * The status of a given dataview entry.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.KxDataviewStatus? = null
        /**
         * The error message when a failed state occurs.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxDataviewListEntry) : this() {
            this.activeVersions = x.activeVersions
            this.autoUpdate = x.autoUpdate
            this.availabilityZoneId = x.availabilityZoneId
            this.azMode = x.azMode
            this.changesetId = x.changesetId
            this.createdTimestamp = x.createdTimestamp
            this.databaseName = x.databaseName
            this.dataviewName = x.dataviewName
            this.description = x.description
            this.environmentId = x.environmentId
            this.lastModifiedTimestamp = x.lastModifiedTimestamp
            this.segmentConfigurations = x.segmentConfigurations
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxDataviewListEntry = KxDataviewListEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
