// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a kdb cluster.
 */
public class KxCluster private constructor(builder: Builder) {
    /**
     * The availability zone identifiers for the requested regions.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The number of availability zones assigned per cluster. This can be one of the following:
     * + `SINGLE` – Assigns one availability zone per cluster.
     * + `MULTI` – Assigns all the availability zones per cluster.
     */
    public val azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = builder.azMode
    /**
     * A description of the cluster.
     */
    public val clusterDescription: kotlin.String? = builder.clusterDescription
    /**
     * A unique name for the cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * Specifies the type of KDB database that is being created. The following types are available:
     * + HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.
     * + RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * + GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.
     * + GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
     * + Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
     */
    public val clusterType: aws.sdk.kotlin.services.finspace.model.KxClusterType? = builder.clusterType
    /**
     * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * Specifies a Q program that will be run at launch of a cluster. It is a relative path within *.zip* file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, `somedir/init.q`.
     */
    public val initializationScript: kotlin.String? = builder.initializationScript
    /**
     * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimestamp
    /**
     * A version of the FinSpace managed kdb to run.
     */
    public val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * The status of a cluster.
     * + PENDING – The cluster is pending creation.
     * + CREATING –The cluster creation process is in progress.
     * + CREATE_FAILED– The cluster creation process has failed.
     * + RUNNING – The cluster creation process is running.
     * + UPDATING – The cluster is in the process of being updated.
     * +  DELETING – The cluster is in the process of being deleted.
     * + DELETED – The cluster has been deleted.
     * + DELETE_FAILED – The cluster failed to delete.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.KxClusterStatus? = builder.status
    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * A list of volumes attached to the cluster.
     */
    public val volumes: List<Volume>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxCluster(")
        append("availabilityZoneId=$availabilityZoneId,")
        append("azMode=$azMode,")
        append("clusterDescription=$clusterDescription,")
        append("clusterName=$clusterName,")
        append("clusterType=$clusterType,")
        append("createdTimestamp=$createdTimestamp,")
        append("executionRole=$executionRole,")
        append("initializationScript=$initializationScript,")
        append("lastModifiedTimestamp=$lastModifiedTimestamp,")
        append("releaseLabel=$releaseLabel,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("volumes=$volumes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneId?.hashCode() ?: 0
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (clusterDescription?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (initializationScript?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxCluster

        if (availabilityZoneId != other.availabilityZoneId) return false
        if (azMode != other.azMode) return false
        if (clusterDescription != other.clusterDescription) return false
        if (clusterName != other.clusterName) return false
        if (clusterType != other.clusterType) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (executionRole != other.executionRole) return false
        if (initializationScript != other.initializationScript) return false
        if (lastModifiedTimestamp != other.lastModifiedTimestamp) return false
        if (releaseLabel != other.releaseLabel) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxCluster = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The availability zone identifiers for the requested regions.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * The number of availability zones assigned per cluster. This can be one of the following:
         * + `SINGLE` – Assigns one availability zone per cluster.
         * + `MULTI` – Assigns all the availability zones per cluster.
         */
        public var azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = null
        /**
         * A description of the cluster.
         */
        public var clusterDescription: kotlin.String? = null
        /**
         * A unique name for the cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * Specifies the type of KDB database that is being created. The following types are available:
         * + HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.
         * + RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
         * + GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.
         * + GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
         * + Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
         */
        public var clusterType: aws.sdk.kotlin.services.finspace.model.KxClusterType? = null
        /**
         * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
         */
        public var executionRole: kotlin.String? = null
        /**
         * Specifies a Q program that will be run at launch of a cluster. It is a relative path within *.zip* file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, `somedir/init.q`.
         */
        public var initializationScript: kotlin.String? = null
        /**
         * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A version of the FinSpace managed kdb to run.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * The status of a cluster.
         * + PENDING – The cluster is pending creation.
         * + CREATING –The cluster creation process is in progress.
         * + CREATE_FAILED– The cluster creation process has failed.
         * + RUNNING – The cluster creation process is running.
         * + UPDATING – The cluster is in the process of being updated.
         * +  DELETING – The cluster is in the process of being deleted.
         * + DELETED – The cluster has been deleted.
         * + DELETE_FAILED – The cluster failed to delete.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.KxClusterStatus? = null
        /**
         * The error message when a failed state occurs.
         */
        public var statusReason: kotlin.String? = null
        /**
         * A list of volumes attached to the cluster.
         */
        public var volumes: List<Volume>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxCluster) : this() {
            this.availabilityZoneId = x.availabilityZoneId
            this.azMode = x.azMode
            this.clusterDescription = x.clusterDescription
            this.clusterName = x.clusterName
            this.clusterType = x.clusterType
            this.createdTimestamp = x.createdTimestamp
            this.executionRole = x.executionRole
            this.initializationScript = x.initializationScript
            this.lastModifiedTimestamp = x.lastModifiedTimestamp
            this.releaseLabel = x.releaseLabel
            this.status = x.status
            this.statusReason = x.statusReason
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxCluster = KxCluster(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
