// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model



/**
 * The configuration for read only disk cache associated with a cluster.
 */
public class KxCacheStorageConfiguration private constructor(builder: Builder) {
    /**
     * The size of cache in Gigabytes.
     */
    public val size: kotlin.Int = requireNotNull(builder.size) { "A non-null value must be provided for size" }
    /**
     * The type of cache storage. The valid values are:
     * + CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
     * + CACHE_250 – This type provides at least 250 MB/s disk access throughput.
     * + CACHE_12 – This type provides at least 12 MB/s disk access throughput.
     *
     * For cache type `CACHE_1000` and `CACHE_250` you can select cache size as 1200 GB or increments of 2400 GB. For cache type `CACHE_12` you can select the cache size in increments of 6000 GB.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxCacheStorageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxCacheStorageConfiguration(")
        append("size=$size,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = size
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxCacheStorageConfiguration

        if (size != other.size) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxCacheStorageConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The size of cache in Gigabytes.
         */
        public var size: kotlin.Int? = null
        /**
         * The type of cache storage. The valid values are:
         * + CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
         * + CACHE_250 – This type provides at least 250 MB/s disk access throughput.
         * + CACHE_12 – This type provides at least 12 MB/s disk access throughput.
         *
         * For cache type `CACHE_1000` and `CACHE_250` you can select cache size as 1200 GB or increments of 2400 GB. For cache type `CACHE_12` you can select the cache size in increments of 6000 GB.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxCacheStorageConfiguration) : this() {
            this.size = x.size
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxCacheStorageConfiguration = KxCacheStorageConfiguration(this)

        internal fun correctErrors(): Builder {
            if (size == null) size = 0
            if (type == null) type = ""
            return this
        }
    }
}
