// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model



/**
 * Represents an FinSpace environment.
 */
public class Environment private constructor(builder: Builder) {
    /**
     * The ID of the AWS account in which the FinSpace environment is created.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The AWS account ID of the dedicated service account associated with your FinSpace environment.
     */
    public val dedicatedServiceAccountId: kotlin.String? = builder.dedicatedServiceAccountId
    /**
     * The description of the FinSpace environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of your FinSpace environment.
     */
    public val environmentArn: kotlin.String? = builder.environmentArn
    /**
     * The identifier of the FinSpace environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The sign-in URL for the web application of your FinSpace environment.
     */
    public val environmentUrl: kotlin.String? = builder.environmentUrl
    /**
     * The authentication mode for the environment.
     */
    public val federationMode: aws.sdk.kotlin.services.finspace.model.FederationMode? = builder.federationMode
    /**
     * Configuration information when authentication mode is FEDERATED.
     */
    public val federationParameters: aws.sdk.kotlin.services.finspace.model.FederationParameters? = builder.federationParameters
    /**
     * The KMS key id used to encrypt in the FinSpace environment.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the FinSpace environment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The URL of the integrated FinSpace notebook environment in your web application.
     */
    public val sageMakerStudioDomainUrl: kotlin.String? = builder.sageMakerStudioDomainUrl
    /**
     * The current status of creation of the FinSpace environment.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.EnvironmentStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.Environment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Environment(")
        append("awsAccountId=$awsAccountId,")
        append("dedicatedServiceAccountId=$dedicatedServiceAccountId,")
        append("description=$description,")
        append("environmentArn=$environmentArn,")
        append("environmentId=$environmentId,")
        append("environmentUrl=$environmentUrl,")
        append("federationMode=$federationMode,")
        append("federationParameters=$federationParameters,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("sageMakerStudioDomainUrl=$sageMakerStudioDomainUrl,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (dedicatedServiceAccountId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentArn?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (environmentUrl?.hashCode() ?: 0)
        result = 31 * result + (federationMode?.hashCode() ?: 0)
        result = 31 * result + (federationParameters?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sageMakerStudioDomainUrl?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Environment

        if (awsAccountId != other.awsAccountId) return false
        if (dedicatedServiceAccountId != other.dedicatedServiceAccountId) return false
        if (description != other.description) return false
        if (environmentArn != other.environmentArn) return false
        if (environmentId != other.environmentId) return false
        if (environmentUrl != other.environmentUrl) return false
        if (federationMode != other.federationMode) return false
        if (federationParameters != other.federationParameters) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (sageMakerStudioDomainUrl != other.sageMakerStudioDomainUrl) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.Environment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the AWS account in which the FinSpace environment is created.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The AWS account ID of the dedicated service account associated with your FinSpace environment.
         */
        public var dedicatedServiceAccountId: kotlin.String? = null
        /**
         * The description of the FinSpace environment.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of your FinSpace environment.
         */
        public var environmentArn: kotlin.String? = null
        /**
         * The identifier of the FinSpace environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The sign-in URL for the web application of your FinSpace environment.
         */
        public var environmentUrl: kotlin.String? = null
        /**
         * The authentication mode for the environment.
         */
        public var federationMode: aws.sdk.kotlin.services.finspace.model.FederationMode? = null
        /**
         * Configuration information when authentication mode is FEDERATED.
         */
        public var federationParameters: aws.sdk.kotlin.services.finspace.model.FederationParameters? = null
        /**
         * The KMS key id used to encrypt in the FinSpace environment.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the FinSpace environment.
         */
        public var name: kotlin.String? = null
        /**
         * The URL of the integrated FinSpace notebook environment in your web application.
         */
        public var sageMakerStudioDomainUrl: kotlin.String? = null
        /**
         * The current status of creation of the FinSpace environment.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.EnvironmentStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.Environment) : this() {
            this.awsAccountId = x.awsAccountId
            this.dedicatedServiceAccountId = x.dedicatedServiceAccountId
            this.description = x.description
            this.environmentArn = x.environmentArn
            this.environmentId = x.environmentId
            this.environmentUrl = x.environmentUrl
            this.federationMode = x.federationMode
            this.federationParameters = x.federationParameters
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.sageMakerStudioDomainUrl = x.sageMakerStudioDomainUrl
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.Environment = Environment(this)

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.FederationParameters] inside the given [block]
         */
        public fun federationParameters(block: aws.sdk.kotlin.services.finspace.model.FederationParameters.Builder.() -> kotlin.Unit) {
            this.federationParameters = aws.sdk.kotlin.services.finspace.model.FederationParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
