// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateKxClusterResponse private constructor(builder: Builder) {
    /**
     * The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
     */
    public val autoScalingConfiguration: aws.sdk.kotlin.services.finspace.model.AutoScalingConfiguration? = builder.autoScalingConfiguration
    /**
     * The availability zone identifiers for the requested regions.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The number of availability zones you want to assign per cluster. This can be one of the following
     * + `SINGLE` – Assigns one availability zone per cluster.
     * + `MULTI` – Assigns all the availability zones per cluster.
     */
    public val azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = builder.azMode
    /**
     * The configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store.
     */
    public val cacheStorageConfigurations: List<KxCacheStorageConfiguration>? = builder.cacheStorageConfigurations
    /**
     * A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and number of instances.
     */
    public val capacityConfiguration: aws.sdk.kotlin.services.finspace.model.CapacityConfiguration? = builder.capacityConfiguration
    /**
     * A description of the cluster.
     */
    public val clusterDescription: kotlin.String? = builder.clusterDescription
    /**
     * A unique name for the cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * Specifies the type of KDB database that is being created. The following types are available:
     * + HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.
     * + RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * + GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.
     * + GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
     * + Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
     */
    public val clusterType: aws.sdk.kotlin.services.finspace.model.KxClusterType? = builder.clusterType
    /**
     * The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of the S3 source bucket, location, S3 object version, and the relative path from where the custom code is loaded into the cluster.
     */
    public val code: aws.sdk.kotlin.services.finspace.model.CodeConfiguration? = builder.code
    /**
     * Defines the key-value pairs to make them available inside the cluster.
     */
    public val commandLineArguments: List<KxCommandLineArgument>? = builder.commandLineArguments
    /**
     * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * A list of databases that will be available for querying.
     */
    public val databases: List<KxDatabaseConfiguration>? = builder.databases
    /**
     * A unique identifier for the kdb environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * Specifies a Q program that will be run at launch of a cluster. It is a relative path within *.zip* file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, `somedir/init.q`.
     */
    public val initializationScript: kotlin.String? = builder.initializationScript
    /**
     * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimestamp
    /**
     * A version of the FinSpace managed kdb to run.
     */
    public val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * The size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `clusterType` as RDB. All the data written to this storage space is lost when the cluster node is restarted.
     */
    public val savedownStorageConfiguration: aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration? = builder.savedownStorageConfiguration
    /**
     * The structure that stores the configuration details of a scaling group.
     */
    public val scalingGroupConfiguration: aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration? = builder.scalingGroupConfiguration
    /**
     * The status of cluster creation.
     * + PENDING – The cluster is pending creation.
     * + CREATING – The cluster creation process is in progress.
     * + CREATE_FAILED – The cluster creation process has failed.
     * + RUNNING – The cluster creation process is running.
     * + UPDATING – The cluster is in the process of being updated.
     * + DELETING – The cluster is in the process of being deleted.
     * + DELETED – The cluster has been deleted.
     * + DELETE_FAILED – The cluster failed to delete.
     */
    public val status: aws.sdk.kotlin.services.finspace.model.KxClusterStatus? = builder.status
    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * A configuration to store the Tickerplant logs. It consists of a list of volumes that will be mounted to your cluster. For the cluster type `Tickerplant`, the location of the TP volume on the cluster will be available by using the global variable `.aws.tp_log_path`.
     */
    public val tickerplantLogConfiguration: aws.sdk.kotlin.services.finspace.model.TickerplantLogConfiguration? = builder.tickerplantLogConfiguration
    /**
     * A list of volumes mounted on the cluster.
     */
    public val volumes: List<Volume>? = builder.volumes
    /**
     * Configuration details about the network where the Privatelink endpoint of the cluster resides.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.finspace.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.CreateKxClusterResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKxClusterResponse(")
        append("autoScalingConfiguration=$autoScalingConfiguration,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("azMode=$azMode,")
        append("cacheStorageConfigurations=$cacheStorageConfigurations,")
        append("capacityConfiguration=$capacityConfiguration,")
        append("clusterDescription=$clusterDescription,")
        append("clusterName=$clusterName,")
        append("clusterType=$clusterType,")
        append("code=$code,")
        append("commandLineArguments=$commandLineArguments,")
        append("createdTimestamp=$createdTimestamp,")
        append("databases=$databases,")
        append("environmentId=$environmentId,")
        append("executionRole=$executionRole,")
        append("initializationScript=$initializationScript,")
        append("lastModifiedTimestamp=$lastModifiedTimestamp,")
        append("releaseLabel=$releaseLabel,")
        append("savedownStorageConfiguration=$savedownStorageConfiguration,")
        append("scalingGroupConfiguration=$scalingGroupConfiguration,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tickerplantLogConfiguration=$tickerplantLogConfiguration,")
        append("volumes=$volumes,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfiguration?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (cacheStorageConfigurations?.hashCode() ?: 0)
        result = 31 * result + (capacityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (clusterDescription?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (commandLineArguments?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (databases?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (initializationScript?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (savedownStorageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scalingGroupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tickerplantLogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKxClusterResponse

        if (autoScalingConfiguration != other.autoScalingConfiguration) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (azMode != other.azMode) return false
        if (cacheStorageConfigurations != other.cacheStorageConfigurations) return false
        if (capacityConfiguration != other.capacityConfiguration) return false
        if (clusterDescription != other.clusterDescription) return false
        if (clusterName != other.clusterName) return false
        if (clusterType != other.clusterType) return false
        if (code != other.code) return false
        if (commandLineArguments != other.commandLineArguments) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (databases != other.databases) return false
        if (environmentId != other.environmentId) return false
        if (executionRole != other.executionRole) return false
        if (initializationScript != other.initializationScript) return false
        if (lastModifiedTimestamp != other.lastModifiedTimestamp) return false
        if (releaseLabel != other.releaseLabel) return false
        if (savedownStorageConfiguration != other.savedownStorageConfiguration) return false
        if (scalingGroupConfiguration != other.scalingGroupConfiguration) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tickerplantLogConfiguration != other.tickerplantLogConfiguration) return false
        if (volumes != other.volumes) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.CreateKxClusterResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration based on which FinSpace will scale in or scale out nodes in your cluster.
         */
        public var autoScalingConfiguration: aws.sdk.kotlin.services.finspace.model.AutoScalingConfiguration? = null
        /**
         * The availability zone identifiers for the requested regions.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * The number of availability zones you want to assign per cluster. This can be one of the following
         * + `SINGLE` – Assigns one availability zone per cluster.
         * + `MULTI` – Assigns all the availability zones per cluster.
         */
        public var azMode: aws.sdk.kotlin.services.finspace.model.KxAzMode? = null
        /**
         * The configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store.
         */
        public var cacheStorageConfigurations: List<KxCacheStorageConfiguration>? = null
        /**
         * A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and number of instances.
         */
        public var capacityConfiguration: aws.sdk.kotlin.services.finspace.model.CapacityConfiguration? = null
        /**
         * A description of the cluster.
         */
        public var clusterDescription: kotlin.String? = null
        /**
         * A unique name for the cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * Specifies the type of KDB database that is being created. The following types are available:
         * + HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.
         * + RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
         * + GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.
         * + GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
         * + Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
         */
        public var clusterType: aws.sdk.kotlin.services.finspace.model.KxClusterType? = null
        /**
         * The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of the S3 source bucket, location, S3 object version, and the relative path from where the custom code is loaded into the cluster.
         */
        public var code: aws.sdk.kotlin.services.finspace.model.CodeConfiguration? = null
        /**
         * Defines the key-value pairs to make them available inside the cluster.
         */
        public var commandLineArguments: List<KxCommandLineArgument>? = null
        /**
         * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of databases that will be available for querying.
         */
        public var databases: List<KxDatabaseConfiguration>? = null
        /**
         * A unique identifier for the kdb environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
         */
        public var executionRole: kotlin.String? = null
        /**
         * Specifies a Q program that will be run at launch of a cluster. It is a relative path within *.zip* file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, `somedir/init.q`.
         */
        public var initializationScript: kotlin.String? = null
        /**
         * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A version of the FinSpace managed kdb to run.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * The size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `clusterType` as RDB. All the data written to this storage space is lost when the cluster node is restarted.
         */
        public var savedownStorageConfiguration: aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration? = null
        /**
         * The structure that stores the configuration details of a scaling group.
         */
        public var scalingGroupConfiguration: aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration? = null
        /**
         * The status of cluster creation.
         * + PENDING – The cluster is pending creation.
         * + CREATING – The cluster creation process is in progress.
         * + CREATE_FAILED – The cluster creation process has failed.
         * + RUNNING – The cluster creation process is running.
         * + UPDATING – The cluster is in the process of being updated.
         * + DELETING – The cluster is in the process of being deleted.
         * + DELETED – The cluster has been deleted.
         * + DELETE_FAILED – The cluster failed to delete.
         */
        public var status: aws.sdk.kotlin.services.finspace.model.KxClusterStatus? = null
        /**
         * The error message when a failed state occurs.
         */
        public var statusReason: kotlin.String? = null
        /**
         * A configuration to store the Tickerplant logs. It consists of a list of volumes that will be mounted to your cluster. For the cluster type `Tickerplant`, the location of the TP volume on the cluster will be available by using the global variable `.aws.tp_log_path`.
         */
        public var tickerplantLogConfiguration: aws.sdk.kotlin.services.finspace.model.TickerplantLogConfiguration? = null
        /**
         * A list of volumes mounted on the cluster.
         */
        public var volumes: List<Volume>? = null
        /**
         * Configuration details about the network where the Privatelink endpoint of the cluster resides.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.finspace.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.CreateKxClusterResponse) : this() {
            this.autoScalingConfiguration = x.autoScalingConfiguration
            this.availabilityZoneId = x.availabilityZoneId
            this.azMode = x.azMode
            this.cacheStorageConfigurations = x.cacheStorageConfigurations
            this.capacityConfiguration = x.capacityConfiguration
            this.clusterDescription = x.clusterDescription
            this.clusterName = x.clusterName
            this.clusterType = x.clusterType
            this.code = x.code
            this.commandLineArguments = x.commandLineArguments
            this.createdTimestamp = x.createdTimestamp
            this.databases = x.databases
            this.environmentId = x.environmentId
            this.executionRole = x.executionRole
            this.initializationScript = x.initializationScript
            this.lastModifiedTimestamp = x.lastModifiedTimestamp
            this.releaseLabel = x.releaseLabel
            this.savedownStorageConfiguration = x.savedownStorageConfiguration
            this.scalingGroupConfiguration = x.scalingGroupConfiguration
            this.status = x.status
            this.statusReason = x.statusReason
            this.tickerplantLogConfiguration = x.tickerplantLogConfiguration
            this.volumes = x.volumes
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.CreateKxClusterResponse = CreateKxClusterResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.AutoScalingConfiguration] inside the given [block]
         */
        public fun autoScalingConfiguration(block: aws.sdk.kotlin.services.finspace.model.AutoScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.autoScalingConfiguration = aws.sdk.kotlin.services.finspace.model.AutoScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.CapacityConfiguration] inside the given [block]
         */
        public fun capacityConfiguration(block: aws.sdk.kotlin.services.finspace.model.CapacityConfiguration.Builder.() -> kotlin.Unit) {
            this.capacityConfiguration = aws.sdk.kotlin.services.finspace.model.CapacityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.CodeConfiguration] inside the given [block]
         */
        public fun code(block: aws.sdk.kotlin.services.finspace.model.CodeConfiguration.Builder.() -> kotlin.Unit) {
            this.code = aws.sdk.kotlin.services.finspace.model.CodeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration] inside the given [block]
         */
        public fun savedownStorageConfiguration(block: aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration.Builder.() -> kotlin.Unit) {
            this.savedownStorageConfiguration = aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration] inside the given [block]
         */
        public fun scalingGroupConfiguration(block: aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingGroupConfiguration = aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.TickerplantLogConfiguration] inside the given [block]
         */
        public fun tickerplantLogConfiguration(block: aws.sdk.kotlin.services.finspace.model.TickerplantLogConfiguration.Builder.() -> kotlin.Unit) {
            this.tickerplantLogConfiguration = aws.sdk.kotlin.services.finspace.model.TickerplantLogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.finspace.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.finspace.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
