// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model



public class CreateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:
     * + `arn:aws:finspace:${Region}::data-bundle/capital-markets-sample` - Contains sample Capital Markets datasets, categories and controlled vocabularies.
     * + `arn:aws:finspace:${Region}::data-bundle/taq` (default) - Contains trades and quotes data in addition to sample Capital Markets data.
     */
    public val dataBundles: List<String>? = builder.dataBundles
    /**
     * The description of the FinSpace environment to be created.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Authentication mode for the environment.
     * + `FEDERATED` - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     * + `LOCAL` - Users access FinSpace via email and password managed within the FinSpace environment.
     */
    public val federationMode: aws.sdk.kotlin.services.finspace.model.FederationMode? = builder.federationMode
    /**
     * Configuration information when authentication mode is FEDERATED.
     */
    public val federationParameters: aws.sdk.kotlin.services.finspace.model.FederationParameters? = builder.federationParameters
    /**
     * The KMS key id to encrypt your data in the FinSpace environment.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the FinSpace environment to be created.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Configuration information for the superuser.
     */
    public val superuserParameters: aws.sdk.kotlin.services.finspace.model.SuperuserParameters? = builder.superuserParameters
    /**
     * Add tags to your FinSpace environment.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.CreateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentRequest(")
        append("dataBundles=$dataBundles,")
        append("description=$description,")
        append("federationMode=$federationMode,")
        append("federationParameters=$federationParameters,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("superuserParameters=$superuserParameters,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataBundles?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (federationMode?.hashCode() ?: 0)
        result = 31 * result + (federationParameters?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (superuserParameters?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEnvironmentRequest

        if (dataBundles != other.dataBundles) return false
        if (description != other.description) return false
        if (federationMode != other.federationMode) return false
        if (federationParameters != other.federationParameters) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (superuserParameters != other.superuserParameters) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.CreateEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:
         * + `arn:aws:finspace:${Region}::data-bundle/capital-markets-sample` - Contains sample Capital Markets datasets, categories and controlled vocabularies.
         * + `arn:aws:finspace:${Region}::data-bundle/taq` (default) - Contains trades and quotes data in addition to sample Capital Markets data.
         */
        public var dataBundles: List<String>? = null
        /**
         * The description of the FinSpace environment to be created.
         */
        public var description: kotlin.String? = null
        /**
         * Authentication mode for the environment.
         * + `FEDERATED` - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
         * + `LOCAL` - Users access FinSpace via email and password managed within the FinSpace environment.
         */
        public var federationMode: aws.sdk.kotlin.services.finspace.model.FederationMode? = null
        /**
         * Configuration information when authentication mode is FEDERATED.
         */
        public var federationParameters: aws.sdk.kotlin.services.finspace.model.FederationParameters? = null
        /**
         * The KMS key id to encrypt your data in the FinSpace environment.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the FinSpace environment to be created.
         */
        public var name: kotlin.String? = null
        /**
         * Configuration information for the superuser.
         */
        public var superuserParameters: aws.sdk.kotlin.services.finspace.model.SuperuserParameters? = null
        /**
         * Add tags to your FinSpace environment.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.CreateEnvironmentRequest) : this() {
            this.dataBundles = x.dataBundles
            this.description = x.description
            this.federationMode = x.federationMode
            this.federationParameters = x.federationParameters
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.superuserParameters = x.superuserParameters
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.CreateEnvironmentRequest = CreateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.FederationParameters] inside the given [block]
         */
        public fun federationParameters(block: aws.sdk.kotlin.services.finspace.model.FederationParameters.Builder.() -> kotlin.Unit) {
            this.federationParameters = aws.sdk.kotlin.services.finspace.model.FederationParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.finspace.model.SuperuserParameters] inside the given [block]
         */
        public fun superuserParameters(block: aws.sdk.kotlin.services.finspace.model.SuperuserParameters.Builder.() -> kotlin.Unit) {
            this.superuserParameters = aws.sdk.kotlin.services.finspace.model.SuperuserParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
