// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model



/**
 * A list of change request objects.
 */
public class ChangeRequest private constructor(builder: Builder) {
    /**
     * Defines the type of change request. A `changeType` can have the following values:
     * + PUT – Adds or updates files in a database.
     * + DELETE – Deletes files in a database.
     */
    public val changeType: aws.sdk.kotlin.services.finspace.model.ChangeType = requireNotNull(builder.changeType) { "A non-null value must be provided for changeType" }
    /**
     * Defines the path within the database directory.
     */
    public val dbPath: kotlin.String = requireNotNull(builder.dbPath) { "A non-null value must be provided for dbPath" }
    /**
     * Defines the S3 path of the source file that is required to add or update files in a database.
     */
    public val s3Path: kotlin.String? = builder.s3Path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.ChangeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeRequest(")
        append("changeType=$changeType,")
        append("dbPath=$dbPath,")
        append("s3Path=$s3Path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeType.hashCode()
        result = 31 * result + (dbPath.hashCode())
        result = 31 * result + (s3Path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeRequest

        if (changeType != other.changeType) return false
        if (dbPath != other.dbPath) return false
        if (s3Path != other.s3Path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.ChangeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines the type of change request. A `changeType` can have the following values:
         * + PUT – Adds or updates files in a database.
         * + DELETE – Deletes files in a database.
         */
        public var changeType: aws.sdk.kotlin.services.finspace.model.ChangeType? = null
        /**
         * Defines the path within the database directory.
         */
        public var dbPath: kotlin.String? = null
        /**
         * Defines the S3 path of the source file that is required to add or update files in a database.
         */
        public var s3Path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.ChangeRequest) : this() {
            this.changeType = x.changeType
            this.dbPath = x.dbPath
            this.s3Path = x.s3Path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.ChangeRequest = ChangeRequest(this)

        internal fun correctErrors(): Builder {
            if (changeType == null) changeType = ChangeType.SdkUnknown("no value provided")
            if (dbPath == null) dbPath = ""
            return this
        }
    }
}
