// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.serde

import aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthorizationType
import aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters
import aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionAuthRequestParameters
import aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateConnectionOperationSerializer: HttpSerializer.NonStreaming<UpdateConnectionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateConnectionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateConnectionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateConnectionOperationBody(context: ExecutionContext, input: UpdateConnectionRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AuthParameters"))
    val AUTHORIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthorizationType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val INVOCATIONCONNECTIVITYPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InvocationConnectivityParameters"))
    val KMSKEYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyIdentifier"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHPARAMETERS_DESCRIPTOR)
        field(AUTHORIZATIONTYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INVOCATIONCONNECTIVITYPARAMETERS_DESCRIPTOR)
        field(KMSKEYIDENTIFIER_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authParameters?.let { field(AUTHPARAMETERS_DESCRIPTOR, it, ::serializeUpdateConnectionAuthRequestParametersDocument) }
        input.authorizationType?.let { field(AUTHORIZATIONTYPE_DESCRIPTOR, it.value) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.invocationConnectivityParameters?.let { field(INVOCATIONCONNECTIVITYPARAMETERS_DESCRIPTOR, it, ::serializeConnectivityResourceParametersDocument) }
        input.kmsKeyIdentifier?.let { field(KMSKEYIDENTIFIER_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
