// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.serde

import aws.sdk.kotlin.services.eventbridge.model.DescribeEndpointResponse
import aws.sdk.kotlin.services.eventbridge.model.EndpointEventBus
import aws.sdk.kotlin.services.eventbridge.model.EndpointState
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.sdk.kotlin.services.eventbridge.model.ReplicationConfig
import aws.sdk.kotlin.services.eventbridge.model.RoutingConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeEndpointOperationDeserializer: HttpDeserializer.NonStreaming<DescribeEndpointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEndpointError(context, call, payload)
        }
        val builder = DescribeEndpointResponse.Builder()

        if (payload != null) {
            deserializeDescribeEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeEndpointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EventBridgeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEndpointOperationBody(builder: DescribeEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDPOINTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointId"))
    val ENDPOINTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointUrl"))
    val EVENTBUSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EventBuses"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REPLICATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReplicationConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val ROUTINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RoutingConfig"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STATEREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDPOINTID_DESCRIPTOR)
        field(ENDPOINTURL_DESCRIPTOR)
        field(EVENTBUSES_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REPLICATIONCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(ROUTINGCONFIG_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATEREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDPOINTID_DESCRIPTOR.index -> builder.endpointId = deserializeString()
                ENDPOINTURL_DESCRIPTOR.index -> builder.endpointUrl = deserializeString()
                EVENTBUSES_DESCRIPTOR.index -> builder.eventBuses =
                    deserializer.deserializeList(EVENTBUSES_DESCRIPTOR) {
                        val col0 = mutableListOf<EndpointEventBus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEndpointEventBusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REPLICATIONCONFIG_DESCRIPTOR.index -> builder.replicationConfig = deserializeReplicationConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                ROUTINGCONFIG_DESCRIPTOR.index -> builder.routingConfig = deserializeRoutingConfigDocument(deserializer)
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { EndpointState.fromValue(it) }
                STATEREASON_DESCRIPTOR.index -> builder.stateReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
