// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.serde

import aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthResponseParameters
import aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthorizationType
import aws.sdk.kotlin.services.eventbridge.model.ConnectionState
import aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionConnectivityParameters
import aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResponse
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeConnectionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeConnectionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeConnectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeConnectionError(context, call, payload)
        }
        val builder = DescribeConnectionResponse.Builder()

        if (payload != null) {
            deserializeDescribeConnectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeConnectionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EventBridgeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeConnectionOperationBody(builder: DescribeConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AuthParameters"))
    val AUTHORIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthorizationType"))
    val CONNECTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionArn"))
    val CONNECTIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ConnectionState"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val INVOCATIONCONNECTIVITYPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InvocationConnectivityParameters"))
    val KMSKEYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyIdentifier"))
    val LASTAUTHORIZEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastAuthorizedTime"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SECRETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretArn"))
    val STATEREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHPARAMETERS_DESCRIPTOR)
        field(AUTHORIZATIONTYPE_DESCRIPTOR)
        field(CONNECTIONARN_DESCRIPTOR)
        field(CONNECTIONSTATE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INVOCATIONCONNECTIVITYPARAMETERS_DESCRIPTOR)
        field(KMSKEYIDENTIFIER_DESCRIPTOR)
        field(LASTAUTHORIZEDTIME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SECRETARN_DESCRIPTOR)
        field(STATEREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHPARAMETERS_DESCRIPTOR.index -> builder.authParameters = deserializeConnectionAuthResponseParametersDocument(deserializer)
                AUTHORIZATIONTYPE_DESCRIPTOR.index -> builder.authorizationType = deserializeString().let { ConnectionAuthorizationType.fromValue(it) }
                CONNECTIONARN_DESCRIPTOR.index -> builder.connectionArn = deserializeString()
                CONNECTIONSTATE_DESCRIPTOR.index -> builder.connectionState = deserializeString().let { ConnectionState.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INVOCATIONCONNECTIVITYPARAMETERS_DESCRIPTOR.index -> builder.invocationConnectivityParameters = deserializeDescribeConnectionConnectivityParametersDocument(deserializer)
                KMSKEYIDENTIFIER_DESCRIPTOR.index -> builder.kmsKeyIdentifier = deserializeString()
                LASTAUTHORIZEDTIME_DESCRIPTOR.index -> builder.lastAuthorizedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SECRETARN_DESCRIPTOR.index -> builder.secretArn = deserializeString()
                STATEREASON_DESCRIPTOR.index -> builder.stateReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
