// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.serde

import aws.sdk.kotlin.services.eventbridge.model.ArchiveState
import aws.sdk.kotlin.services.eventbridge.model.DescribeArchiveResponse
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeArchiveOperationDeserializer: HttpDeserializer.NonStreaming<DescribeArchiveResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeArchiveResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeArchiveError(context, call, payload)
        }
        val builder = DescribeArchiveResponse.Builder()

        if (payload != null) {
            deserializeDescribeArchiveOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeArchiveError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EventBridgeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeArchiveOperationBody(builder: DescribeArchiveResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARCHIVEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveArn"))
    val ARCHIVENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveName"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EVENTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EventCount"))
    val EVENTPATTERN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventPattern"))
    val EVENTSOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventSourceArn"))
    val KMSKEYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyIdentifier"))
    val RETENTIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RetentionDays"))
    val SIZEBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("SizeBytes"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STATEREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHIVEARN_DESCRIPTOR)
        field(ARCHIVENAME_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EVENTCOUNT_DESCRIPTOR)
        field(EVENTPATTERN_DESCRIPTOR)
        field(EVENTSOURCEARN_DESCRIPTOR)
        field(KMSKEYIDENTIFIER_DESCRIPTOR)
        field(RETENTIONDAYS_DESCRIPTOR)
        field(SIZEBYTES_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATEREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARCHIVEARN_DESCRIPTOR.index -> builder.archiveArn = deserializeString()
                ARCHIVENAME_DESCRIPTOR.index -> builder.archiveName = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EVENTCOUNT_DESCRIPTOR.index -> builder.eventCount = deserializeLong()
                EVENTPATTERN_DESCRIPTOR.index -> builder.eventPattern = deserializeString()
                EVENTSOURCEARN_DESCRIPTOR.index -> builder.eventSourceArn = deserializeString()
                KMSKEYIDENTIFIER_DESCRIPTOR.index -> builder.kmsKeyIdentifier = deserializeString()
                RETENTIONDAYS_DESCRIPTOR.index -> builder.retentionDays = deserializeInt()
                SIZEBYTES_DESCRIPTOR.index -> builder.sizeBytes = deserializeLong()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ArchiveState.fromValue(it) }
                STATEREASON_DESCRIPTOR.index -> builder.stateReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
