// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the additional parameters to use for the connection.
 */
public class UpdateConnectionAuthRequestParameters private constructor(builder: Builder) {
    /**
     * The authorization parameters for API key authorization.
     */
    public val apiKeyAuthParameters: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters? = builder.apiKeyAuthParameters
    /**
     * The authorization parameters for Basic authorization.
     */
    public val basicAuthParameters: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters? = builder.basicAuthParameters
    /**
     * If you specify a private OAuth endpoint, the parameters for EventBridge to use when authenticating against the endpoint.
     *
     * For more information, see [Authorization methods for connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html) in the **Amazon EventBridge User Guide**.
     */
    public val connectivityParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters? = builder.connectivityParameters
    /**
     * The additional parameters to use for the connection.
     */
    public val invocationHttpParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters? = builder.invocationHttpParameters
    /**
     * The authorization parameters for OAuth authorization.
     */
    public val oAuthParameters: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionOAuthRequestParameters? = builder.oAuthParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionAuthRequestParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConnectionAuthRequestParameters(")
        append("apiKeyAuthParameters=$apiKeyAuthParameters,")
        append("basicAuthParameters=$basicAuthParameters,")
        append("connectivityParameters=$connectivityParameters,")
        append("invocationHttpParameters=$invocationHttpParameters,")
        append("oAuthParameters=$oAuthParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyAuthParameters?.hashCode() ?: 0
        result = 31 * result + (basicAuthParameters?.hashCode() ?: 0)
        result = 31 * result + (connectivityParameters?.hashCode() ?: 0)
        result = 31 * result + (invocationHttpParameters?.hashCode() ?: 0)
        result = 31 * result + (oAuthParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConnectionAuthRequestParameters

        if (apiKeyAuthParameters != other.apiKeyAuthParameters) return false
        if (basicAuthParameters != other.basicAuthParameters) return false
        if (connectivityParameters != other.connectivityParameters) return false
        if (invocationHttpParameters != other.invocationHttpParameters) return false
        if (oAuthParameters != other.oAuthParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionAuthRequestParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authorization parameters for API key authorization.
         */
        public var apiKeyAuthParameters: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters? = null
        /**
         * The authorization parameters for Basic authorization.
         */
        public var basicAuthParameters: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters? = null
        /**
         * If you specify a private OAuth endpoint, the parameters for EventBridge to use when authenticating against the endpoint.
         *
         * For more information, see [Authorization methods for connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html) in the **Amazon EventBridge User Guide**.
         */
        public var connectivityParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters? = null
        /**
         * The additional parameters to use for the connection.
         */
        public var invocationHttpParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters? = null
        /**
         * The authorization parameters for OAuth authorization.
         */
        public var oAuthParameters: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionOAuthRequestParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionAuthRequestParameters) : this() {
            this.apiKeyAuthParameters = x.apiKeyAuthParameters
            this.basicAuthParameters = x.basicAuthParameters
            this.connectivityParameters = x.connectivityParameters
            this.invocationHttpParameters = x.invocationHttpParameters
            this.oAuthParameters = x.oAuthParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionAuthRequestParameters = UpdateConnectionAuthRequestParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters] inside the given [block]
         */
        public fun apiKeyAuthParameters(block: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.Builder.() -> kotlin.Unit) {
            this.apiKeyAuthParameters = aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters] inside the given [block]
         */
        public fun basicAuthParameters(block: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.Builder.() -> kotlin.Unit) {
            this.basicAuthParameters = aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters] inside the given [block]
         */
        public fun connectivityParameters(block: aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters.Builder.() -> kotlin.Unit) {
            this.connectivityParameters = aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters] inside the given [block]
         */
        public fun invocationHttpParameters(block: aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters.Builder.() -> kotlin.Unit) {
            this.invocationHttpParameters = aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionOAuthRequestParameters] inside the given [block]
         */
        public fun oAuthParameters(block: aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionOAuthRequestParameters.Builder.() -> kotlin.Unit) {
            this.oAuthParameters = aws.sdk.kotlin.services.eventbridge.model.UpdateConnectionOAuthRequestParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
