// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateArchiveRequest private constructor(builder: Builder) {
    /**
     * The name of the archive to update.
     */
    public val archiveName: kotlin.String? = builder.archiveName
    /**
     * The description for the archive.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The event pattern to use to filter events sent to the archive.
     */
    public val eventPattern: kotlin.String? = builder.eventPattern
    /**
     * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
     *
     * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to encrypt the archive.
     *
     * For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *Key Management Service Developer Guide*.
     *
     * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we strongly recommend you also specify a customer managed key for any archives for the event bus as well.
     *
     * For more information, see [Encrypting archives](https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html) in the *Amazon EventBridge User Guide*.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The number of days to retain events in the archive.
     */
    public val retentionDays: kotlin.Int? = builder.retentionDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.UpdateArchiveRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateArchiveRequest(")
        append("archiveName=$archiveName,")
        append("description=$description,")
        append("eventPattern=$eventPattern,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("retentionDays=$retentionDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (retentionDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateArchiveRequest

        if (archiveName != other.archiveName) return false
        if (description != other.description) return false
        if (eventPattern != other.eventPattern) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (retentionDays != other.retentionDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.UpdateArchiveRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the archive to update.
         */
        public var archiveName: kotlin.String? = null
        /**
         * The description for the archive.
         */
        public var description: kotlin.String? = null
        /**
         * The event pattern to use to filter events sent to the archive.
         */
        public var eventPattern: kotlin.String? = null
        /**
         * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
         *
         * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to encrypt the archive.
         *
         * For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *Key Management Service Developer Guide*.
         *
         * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we strongly recommend you also specify a customer managed key for any archives for the event bus as well.
         *
         * For more information, see [Encrypting archives](https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html) in the *Amazon EventBridge User Guide*.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The number of days to retain events in the archive.
         */
        public var retentionDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.UpdateArchiveRequest) : this() {
            this.archiveName = x.archiveName
            this.description = x.description
            this.eventPattern = x.eventPattern
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.retentionDays = x.retentionDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.UpdateArchiveRequest = UpdateArchiveRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
