// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

public class TestEventPatternRequest private constructor(builder: Builder) {
    /**
     * The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in [Amazon Web Services Events](https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html), and the following fields are mandatory:
     * + `id`
     * + `account`
     * + `source`
     * + `time`
     * + `region`
     * + `resources`
     * + `detail-type`
     */
    public val event: kotlin.String? = builder.event
    /**
     * The event pattern. For more information, see [Events and Event Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html) in the **Amazon EventBridge User Guide**.
     */
    public val eventPattern: kotlin.String? = builder.eventPattern

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestEventPatternRequest(")
        append("event=$event,")
        append("eventPattern=$eventPattern")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = event?.hashCode() ?: 0
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestEventPatternRequest

        if (event != other.event) return false
        if (eventPattern != other.eventPattern) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in [Amazon Web Services Events](https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html), and the following fields are mandatory:
         * + `id`
         * + `account`
         * + `source`
         * + `time`
         * + `region`
         * + `resources`
         * + `detail-type`
         */
        public var event: kotlin.String? = null
        /**
         * The event pattern. For more information, see [Events and Event Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html) in the **Amazon EventBridge User Guide**.
         */
        public var eventPattern: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest) : this() {
            this.event = x.event
            this.eventPattern = x.eventPattern
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest = TestEventPatternRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
