// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the EC2 instances that are to be sent the command, specified as key-value pairs. Each `RunCommandTarget` block can include only one key, but this key may specify multiple values.
 */
public class RunCommandTarget private constructor(builder: Builder) {
    /**
     * Can be either `tag:`*tag-key* or `InstanceIds`.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * If `Key` is `tag:`*tag-key*, `Values` is a list of tag values. If `Key` is `InstanceIds`, `Values` is a list of Amazon EC2 instance IDs.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.RunCommandTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RunCommandTarget(")
        append("key=$key,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RunCommandTarget

        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.RunCommandTarget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Can be either `tag:`*tag-key* or `InstanceIds`.
         */
        public var key: kotlin.String? = null
        /**
         * If `Key` is `tag:`*tag-key*, `Values` is a list of tag values. If `Key` is `InstanceIds`, `Values` is a list of Amazon EC2 instance IDs.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.RunCommandTarget) : this() {
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.RunCommandTarget = RunCommandTarget(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (values == null) values = emptyList()
            return this
        }
    }
}
