// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutRuleRequest private constructor(builder: Builder) {
    /**
     * A description of the rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.
     */
    public val eventBusName: kotlin.String? = builder.eventBusName
    /**
     * The event pattern. For more information, see [Amazon EventBridge event patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html) in the **Amazon EventBridge User Guide**.
     */
    public val eventPattern: kotlin.String? = builder.eventPattern
    /**
     * The name of the rule that you are creating or updating.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the IAM role associated with the rule.
     *
     * If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a `RoleArn` with proper permissions in the `Target` structure, instead of here in this parameter.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The state of the rule.
     *
     * Valid values include:
     * + `DISABLED`: The rule is disabled. EventBridge does not match any events against the rule.
     * + `ENABLED`: The rule is enabled. EventBridge matches events against the rule, *except* for Amazon Web Services management events delivered through CloudTrail.
     * + `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`: The rule is enabled for all events, including Amazon Web Services management events delivered through CloudTrail.Management events provide visibility into management operations that are performed on resources in your Amazon Web Services account. These are also known as control plane operations. For more information, see [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html#logging-management-events) in the *CloudTrail User Guide*, and [Filtering management events from Amazon Web Services services](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-cloudtrail) in the **Amazon EventBridge User Guide**.This value is only valid for rules on the [default](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is-how-it-works-concepts.html#eb-bus-concepts-buses) event bus or [custom event buses](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-event-bus.html). It does not apply to [partner event buses](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas.html).
     */
    public val state: aws.sdk.kotlin.services.eventbridge.model.RuleState? = builder.state
    /**
     * The list of key-value pairs to associate with the rule.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRuleRequest(")
        append("description=$description,")
        append("eventBusName=$eventBusName,")
        append("eventPattern=$eventPattern,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("scheduleExpression=$scheduleExpression,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (eventBusName?.hashCode() ?: 0)
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRuleRequest

        if (description != other.description) return false
        if (eventBusName != other.eventBusName) return false
        if (eventPattern != other.eventPattern) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the rule.
         */
        public var description: kotlin.String? = null
        /**
         * The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.
         */
        public var eventBusName: kotlin.String? = null
        /**
         * The event pattern. For more information, see [Amazon EventBridge event patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html) in the **Amazon EventBridge User Guide**.
         */
        public var eventPattern: kotlin.String? = null
        /**
         * The name of the rule that you are creating or updating.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role associated with the rule.
         *
         * If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a `RoleArn` with proper permissions in the `Target` structure, instead of here in this parameter.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * The state of the rule.
         *
         * Valid values include:
         * + `DISABLED`: The rule is disabled. EventBridge does not match any events against the rule.
         * + `ENABLED`: The rule is enabled. EventBridge matches events against the rule, *except* for Amazon Web Services management events delivered through CloudTrail.
         * + `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`: The rule is enabled for all events, including Amazon Web Services management events delivered through CloudTrail.Management events provide visibility into management operations that are performed on resources in your Amazon Web Services account. These are also known as control plane operations. For more information, see [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html#logging-management-events) in the *CloudTrail User Guide*, and [Filtering management events from Amazon Web Services services](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-cloudtrail) in the **Amazon EventBridge User Guide**.This value is only valid for rules on the [default](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is-how-it-works-concepts.html#eb-bus-concepts-buses) event bus or [custom event buses](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-event-bus.html). It does not apply to [partner event buses](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas.html).
         */
        public var state: aws.sdk.kotlin.services.eventbridge.model.RuleState? = null
        /**
         * The list of key-value pairs to associate with the rule.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest) : this() {
            this.description = x.description
            this.eventBusName = x.eventBusName
            this.eventPattern = x.eventPattern
            this.name = x.name
            this.roleArn = x.roleArn
            this.scheduleExpression = x.scheduleExpression
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest = PutRuleRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
