// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the results of an event submitted to an event bus.
 *
 * If the submission was successful, the entry has the event ID in it. Otherwise, you can use the error code and error message to identify the problem with the entry.
 *
 * For information about the errors that are common to all actions, see [Common Errors](https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html).
 */
public class PutEventsResultEntry private constructor(builder: Builder) {
    /**
     * The error code that indicates why the event submission failed.
     *
     * Retryable errors include:
     * + ` <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html">InternalFailure</a> `The request processing has failed because of an unknown error, exception or failure.
     * + ` <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html">ThrottlingException</a> `The request was denied due to request throttling.
     *
     * Non-retryable errors include:
     * + ` <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html">AccessDeniedException</a> `You do not have sufficient access to perform this action.
     * + `InvalidAccountIdException`The account ID provided is not valid.
     * + `InvalidArgument`A specified parameter is not valid.
     * + `MalformedDetail`The JSON provided is not valid.
     * + `RedactionFailure`Redacting the CloudTrail event failed.
     * + `NotAuthorizedForSourceException`You do not have permissions to publish events with this source onto this event bus.
     * + `NotAuthorizedForDetailTypeException`You do not have permissions to publish events with this detail type onto this event bus.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The error message that explains why the event submission failed.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The ID of the event.
     */
    public val eventId: kotlin.String? = builder.eventId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.PutEventsResultEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutEventsResultEntry(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("eventId=$eventId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (eventId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutEventsResultEntry

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (eventId != other.eventId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.PutEventsResultEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The error code that indicates why the event submission failed.
         *
         * Retryable errors include:
         * + ` <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html">InternalFailure</a> `The request processing has failed because of an unknown error, exception or failure.
         * + ` <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html">ThrottlingException</a> `The request was denied due to request throttling.
         *
         * Non-retryable errors include:
         * + ` <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html">AccessDeniedException</a> `You do not have sufficient access to perform this action.
         * + `InvalidAccountIdException`The account ID provided is not valid.
         * + `InvalidArgument`A specified parameter is not valid.
         * + `MalformedDetail`The JSON provided is not valid.
         * + `RedactionFailure`Redacting the CloudTrail event failed.
         * + `NotAuthorizedForSourceException`You do not have permissions to publish events with this source onto this event bus.
         * + `NotAuthorizedForDetailTypeException`You do not have permissions to publish events with this detail type onto this event bus.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The error message that explains why the event submission failed.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The ID of the event.
         */
        public var eventId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.PutEventsResultEntry) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.eventId = x.eventId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.PutEventsResultEntry = PutEventsResultEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
