// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The logging configuration settings for the event bus.
 *
 * For more information, see [Configuring logs for event buses](https://docs.aws.amazon.com/eb-event-bus-logs.html) in the *EventBridge User Guide*.
 */
public class LogConfig private constructor(builder: Builder) {
    /**
     * Whether EventBridge include detailed event information in the records it generates. Detailed data can be useful for troubleshooting and debugging. This information includes details of the event itself, as well as target details.
     *
     * For more information, see [Including detail data in event bus logs](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data) in the *EventBridge User Guide*.
     */
    public val includeDetail: aws.sdk.kotlin.services.eventbridge.model.IncludeDetail? = builder.includeDetail
    /**
     * The level of logging detail to include. This applies to all log destinations for the event bus.
     *
     * For more information, see [Specifying event bus log level](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level) in the *EventBridge User Guide*.
     */
    public val level: aws.sdk.kotlin.services.eventbridge.model.Level? = builder.level

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.LogConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogConfig(")
        append("includeDetail=$includeDetail,")
        append("level=$level")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeDetail?.hashCode() ?: 0
        result = 31 * result + (level?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogConfig

        if (includeDetail != other.includeDetail) return false
        if (level != other.level) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.LogConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether EventBridge include detailed event information in the records it generates. Detailed data can be useful for troubleshooting and debugging. This information includes details of the event itself, as well as target details.
         *
         * For more information, see [Including detail data in event bus logs](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data) in the *EventBridge User Guide*.
         */
        public var includeDetail: aws.sdk.kotlin.services.eventbridge.model.IncludeDetail? = null
        /**
         * The level of logging detail to include. This applies to all log destinations for the event bus.
         *
         * For more information, see [Specifying event bus log level](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level) in the *EventBridge User Guide*.
         */
        public var level: aws.sdk.kotlin.services.eventbridge.model.Level? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.LogConfig) : this() {
            this.includeDetail = x.includeDetail
            this.level = x.level
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.LogConfig = LogConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
