// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An event bus receives events from a source, uses rules to evaluate them, applies any configured input transformation, and routes them to the appropriate target(s). Your account's default event bus receives events from Amazon Web Services services. A custom event bus can receive events from your custom applications and services. A partner event bus receives events from an event source created by an SaaS partner. These events come from the partners services or applications.
 */
public class EventBus private constructor(builder: Builder) {
    /**
     * The ARN of the event bus.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time the event bus was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The event bus description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time the event bus was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the event bus.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The permissions policy of the event bus, describing which other Amazon Web Services accounts can write events to this event bus.
     */
    public val policy: kotlin.String? = builder.policy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.EventBus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventBus(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("policy=$policy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventBus

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (policy != other.policy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.EventBus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the event bus.
         */
        public var arn: kotlin.String? = null
        /**
         * The time the event bus was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The event bus description.
         */
        public var description: kotlin.String? = null
        /**
         * The time the event bus was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the event bus.
         */
        public var name: kotlin.String? = null
        /**
         * The permissions policy of the event bus, describing which other Amazon Web Services accounts can write events to this event bus.
         */
        public var policy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.EventBus) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.policy = x.policy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.EventBus = EventBus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
