// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeEventBusResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time the event bus was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Configuration details of the Amazon SQS queue for EventBridge to use as a dead-letter queue (DLQ).
     *
     * For more information, see [Using dead-letter queues to process undelivered events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-rule-event-delivery.html#eb-rule-dlq) in the *EventBridge User Guide*.
     */
    public val deadLetterConfig: aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig? = builder.deadLetterConfig
    /**
     * The event bus description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event bus, if one has been specified.
     *
     * For more information, see [Data encryption in EventBridge](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html) in the *Amazon EventBridge User Guide*.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The time the event bus was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The logging configuration settings for the event bus.
     *
     * For more information, see [Configuring logs for event buses](https://docs.aws.amazon.com/eb-event-bus-logs.html) in the *EventBridge User Guide*.
     */
    public val logConfig: aws.sdk.kotlin.services.eventbridge.model.LogConfig? = builder.logConfig
    /**
     * The name of the event bus. Currently, this is always `default`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The policy that enables the external account to send events to your account.
     */
    public val policy: kotlin.String? = builder.policy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.DescribeEventBusResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventBusResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("description=$description,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("logConfig=$logConfig,")
        append("name=$name,")
        append("policy=$policy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (logConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEventBusResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (description != other.description) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (logConfig != other.logConfig) return false
        if (name != other.name) return false
        if (policy != other.policy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.DescribeEventBusResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
         */
        public var arn: kotlin.String? = null
        /**
         * The time the event bus was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configuration details of the Amazon SQS queue for EventBridge to use as a dead-letter queue (DLQ).
         *
         * For more information, see [Using dead-letter queues to process undelivered events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-rule-event-delivery.html#eb-rule-dlq) in the *EventBridge User Guide*.
         */
        public var deadLetterConfig: aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig? = null
        /**
         * The event bus description.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event bus, if one has been specified.
         *
         * For more information, see [Data encryption in EventBridge](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html) in the *Amazon EventBridge User Guide*.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The time the event bus was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The logging configuration settings for the event bus.
         *
         * For more information, see [Configuring logs for event buses](https://docs.aws.amazon.com/eb-event-bus-logs.html) in the *EventBridge User Guide*.
         */
        public var logConfig: aws.sdk.kotlin.services.eventbridge.model.LogConfig? = null
        /**
         * The name of the event bus. Currently, this is always `default`.
         */
        public var name: kotlin.String? = null
        /**
         * The policy that enables the external account to send events to your account.
         */
        public var policy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.DescribeEventBusResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.deadLetterConfig = x.deadLetterConfig
            this.description = x.description
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.lastModifiedTime = x.lastModifiedTime
            this.logConfig = x.logConfig
            this.name = x.name
            this.policy = x.policy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.DescribeEventBusResponse = DescribeEventBusResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig] inside the given [block]
         */
        public fun deadLetterConfig(block: aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.LogConfig] inside the given [block]
         */
        public fun logConfig(block: aws.sdk.kotlin.services.eventbridge.model.LogConfig.Builder.() -> kotlin.Unit) {
            this.logConfig = aws.sdk.kotlin.services.eventbridge.model.LogConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
