// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeConnectionResponse private constructor(builder: Builder) {
    /**
     * The parameters to use for authorization for the connection.
     */
    public val authParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthResponseParameters? = builder.authParameters
    /**
     * The type of authorization specified for the connection.
     */
    public val authorizationType: aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthorizationType? = builder.authorizationType
    /**
     * The ARN of the connection retrieved.
     */
    public val connectionArn: kotlin.String? = builder.connectionArn
    /**
     * The state of the connection retrieved.
     */
    public val connectionState: aws.sdk.kotlin.services.eventbridge.model.ConnectionState? = builder.connectionState
    /**
     * A time stamp for the time that the connection was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description for the connection retrieved.
     */
    public val description: kotlin.String? = builder.description
    /**
     * For connections to private APIs The parameters EventBridge uses to invoke the resource endpoint.
     *
     * For more information, see [Connecting to private APIs](https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html) in the **Amazon EventBridge User Guide**.
     */
    public val invocationConnectivityParameters: aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionConnectivityParameters? = builder.invocationConnectivityParameters
    /**
     * The identifier of the KMS customer managed key for EventBridge to use to encrypt the connection, if one has been specified.
     *
     * For more information, see [Encrypting connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-connections.html) in the *Amazon EventBridge User Guide*.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * A time stamp for the time that the connection was last authorized.
     */
    public val lastAuthorizedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAuthorizedTime
    /**
     * A time stamp for the time that the connection was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the connection retrieved.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the secret created from the authorization parameters specified for the connection.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The reason that the connection is in the current connection state.
     */
    public val stateReason: kotlin.String? = builder.stateReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeConnectionResponse(")
        append("authParameters=$authParameters,")
        append("authorizationType=$authorizationType,")
        append("connectionArn=$connectionArn,")
        append("connectionState=$connectionState,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("invocationConnectivityParameters=$invocationConnectivityParameters,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("lastAuthorizedTime=$lastAuthorizedTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("secretArn=$secretArn,")
        append("stateReason=$stateReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authParameters?.hashCode() ?: 0
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (connectionArn?.hashCode() ?: 0)
        result = 31 * result + (connectionState?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (invocationConnectivityParameters?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (lastAuthorizedTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeConnectionResponse

        if (authParameters != other.authParameters) return false
        if (authorizationType != other.authorizationType) return false
        if (connectionArn != other.connectionArn) return false
        if (connectionState != other.connectionState) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (invocationConnectivityParameters != other.invocationConnectivityParameters) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (lastAuthorizedTime != other.lastAuthorizedTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (secretArn != other.secretArn) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The parameters to use for authorization for the connection.
         */
        public var authParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthResponseParameters? = null
        /**
         * The type of authorization specified for the connection.
         */
        public var authorizationType: aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthorizationType? = null
        /**
         * The ARN of the connection retrieved.
         */
        public var connectionArn: kotlin.String? = null
        /**
         * The state of the connection retrieved.
         */
        public var connectionState: aws.sdk.kotlin.services.eventbridge.model.ConnectionState? = null
        /**
         * A time stamp for the time that the connection was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the connection retrieved.
         */
        public var description: kotlin.String? = null
        /**
         * For connections to private APIs The parameters EventBridge uses to invoke the resource endpoint.
         *
         * For more information, see [Connecting to private APIs](https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html) in the **Amazon EventBridge User Guide**.
         */
        public var invocationConnectivityParameters: aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionConnectivityParameters? = null
        /**
         * The identifier of the KMS customer managed key for EventBridge to use to encrypt the connection, if one has been specified.
         *
         * For more information, see [Encrypting connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-connections.html) in the *Amazon EventBridge User Guide*.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * A time stamp for the time that the connection was last authorized.
         */
        public var lastAuthorizedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A time stamp for the time that the connection was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the connection retrieved.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the secret created from the authorization parameters specified for the connection.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The reason that the connection is in the current connection state.
         */
        public var stateReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResponse) : this() {
            this.authParameters = x.authParameters
            this.authorizationType = x.authorizationType
            this.connectionArn = x.connectionArn
            this.connectionState = x.connectionState
            this.creationTime = x.creationTime
            this.description = x.description
            this.invocationConnectivityParameters = x.invocationConnectivityParameters
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.lastAuthorizedTime = x.lastAuthorizedTime
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.secretArn = x.secretArn
            this.stateReason = x.stateReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResponse = DescribeConnectionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthResponseParameters] inside the given [block]
         */
        public fun authParameters(block: aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthResponseParameters.Builder.() -> kotlin.Unit) {
            this.authParameters = aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthResponseParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionConnectivityParameters] inside the given [block]
         */
        public fun invocationConnectivityParameters(block: aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionConnectivityParameters.Builder.() -> kotlin.Unit) {
            this.invocationConnectivityParameters = aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionConnectivityParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
