// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The parameters for EventBridge to use when invoking the resource endpoint.
 */
public class DescribeConnectionResourceParameters private constructor(builder: Builder) {
    /**
     * For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.
     *
     * For more information, see [ Managing service network resource associations for connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html#connection-private-snra) in the **Amazon EventBridge User Guide**.
     */
    public val resourceAssociationArn: kotlin.String = requireNotNull(builder.resourceAssociationArn) { "A non-null value must be provided for resourceAssociationArn" }
    /**
     * The Amazon Resource Name (ARN) of the resource configuration for the private API.
     */
    public val resourceConfigurationArn: kotlin.String = requireNotNull(builder.resourceConfigurationArn) { "A non-null value must be provided for resourceConfigurationArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResourceParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeConnectionResourceParameters(")
        append("resourceAssociationArn=$resourceAssociationArn,")
        append("resourceConfigurationArn=$resourceConfigurationArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceAssociationArn.hashCode()
        result = 31 * result + (resourceConfigurationArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeConnectionResourceParameters

        if (resourceAssociationArn != other.resourceAssociationArn) return false
        if (resourceConfigurationArn != other.resourceConfigurationArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResourceParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.
         *
         * For more information, see [ Managing service network resource associations for connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html#connection-private-snra) in the **Amazon EventBridge User Guide**.
         */
        public var resourceAssociationArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource configuration for the private API.
         */
        public var resourceConfigurationArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResourceParameters) : this() {
            this.resourceAssociationArn = x.resourceAssociationArn
            this.resourceConfigurationArn = x.resourceConfigurationArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResourceParameters = DescribeConnectionResourceParameters(this)

        internal fun correctErrors(): Builder {
            if (resourceAssociationArn == null) resourceAssociationArn = ""
            if (resourceConfigurationArn == null) resourceConfigurationArn = ""
            return this
        }
    }
}
