// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateConnectionRequest private constructor(builder: Builder) {
    /**
     * The authorization parameters to use to authorize with the endpoint.
     *
     * You must include only authorization parameters for the `AuthorizationType` you specify.
     */
    public val authParameters: aws.sdk.kotlin.services.eventbridge.model.CreateConnectionAuthRequestParameters? = builder.authParameters
    /**
     * The type of authorization to use for the connection.
     *
     * OAUTH tokens are refreshed when a 401 or 407 response is returned.
     */
    public val authorizationType: aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthorizationType? = builder.authorizationType
    /**
     * A description for the connection to create.
     */
    public val description: kotlin.String? = builder.description
    /**
     * For connections to private APIs, the parameters to use for invoking the API.
     *
     * For more information, see [Connecting to private APIs](https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html) in the **Amazon EventBridge User Guide**.
     */
    public val invocationConnectivityParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters? = builder.invocationConnectivityParameters
    /**
     * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
     *
     * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to encrypt the connection.
     *
     * For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *Key Management Service Developer Guide*.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The name for the connection to create.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.CreateConnectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConnectionRequest(")
        append("authParameters=$authParameters,")
        append("authorizationType=$authorizationType,")
        append("description=$description,")
        append("invocationConnectivityParameters=$invocationConnectivityParameters,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authParameters?.hashCode() ?: 0
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (invocationConnectivityParameters?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConnectionRequest

        if (authParameters != other.authParameters) return false
        if (authorizationType != other.authorizationType) return false
        if (description != other.description) return false
        if (invocationConnectivityParameters != other.invocationConnectivityParameters) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.CreateConnectionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authorization parameters to use to authorize with the endpoint.
         *
         * You must include only authorization parameters for the `AuthorizationType` you specify.
         */
        public var authParameters: aws.sdk.kotlin.services.eventbridge.model.CreateConnectionAuthRequestParameters? = null
        /**
         * The type of authorization to use for the connection.
         *
         * OAUTH tokens are refreshed when a 401 or 407 response is returned.
         */
        public var authorizationType: aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthorizationType? = null
        /**
         * A description for the connection to create.
         */
        public var description: kotlin.String? = null
        /**
         * For connections to private APIs, the parameters to use for invoking the API.
         *
         * For more information, see [Connecting to private APIs](https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html) in the **Amazon EventBridge User Guide**.
         */
        public var invocationConnectivityParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters? = null
        /**
         * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
         *
         * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to encrypt the connection.
         *
         * For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *Key Management Service Developer Guide*.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The name for the connection to create.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.CreateConnectionRequest) : this() {
            this.authParameters = x.authParameters
            this.authorizationType = x.authorizationType
            this.description = x.description
            this.invocationConnectivityParameters = x.invocationConnectivityParameters
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.CreateConnectionRequest = CreateConnectionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.CreateConnectionAuthRequestParameters] inside the given [block]
         */
        public fun authParameters(block: aws.sdk.kotlin.services.eventbridge.model.CreateConnectionAuthRequestParameters.Builder.() -> kotlin.Unit) {
            this.authParameters = aws.sdk.kotlin.services.eventbridge.model.CreateConnectionAuthRequestParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters] inside the given [block]
         */
        public fun invocationConnectivityParameters(block: aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters.Builder.() -> kotlin.Unit) {
            this.invocationConnectivityParameters = aws.sdk.kotlin.services.eventbridge.model.ConnectivityResourceParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
