// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateArchiveRequest private constructor(builder: Builder) {
    /**
     * The name for the archive to create.
     */
    public val archiveName: kotlin.String? = builder.archiveName
    /**
     * A description for the archive.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An event pattern to use to filter events sent to the archive.
     */
    public val eventPattern: kotlin.String? = builder.eventPattern
    /**
     * The ARN of the event bus that sends events to the archive.
     */
    public val eventSourceArn: kotlin.String? = builder.eventSourceArn
    /**
     * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
     *
     * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to encrypt the archive.
     *
     * For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *Key Management Service Developer Guide*.
     *
     * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we strongly recommend you also specify a customer managed key for any archives for the event bus as well.
     *
     * For more information, see [Encrypting archives](https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html) in the *Amazon EventBridge User Guide*.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely
     */
    public val retentionDays: kotlin.Int? = builder.retentionDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.CreateArchiveRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateArchiveRequest(")
        append("archiveName=$archiveName,")
        append("description=$description,")
        append("eventPattern=$eventPattern,")
        append("eventSourceArn=$eventSourceArn,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("retentionDays=$retentionDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        result = 31 * result + (eventSourceArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (retentionDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateArchiveRequest

        if (archiveName != other.archiveName) return false
        if (description != other.description) return false
        if (eventPattern != other.eventPattern) return false
        if (eventSourceArn != other.eventSourceArn) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (retentionDays != other.retentionDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.CreateArchiveRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name for the archive to create.
         */
        public var archiveName: kotlin.String? = null
        /**
         * A description for the archive.
         */
        public var description: kotlin.String? = null
        /**
         * An event pattern to use to filter events sent to the archive.
         */
        public var eventPattern: kotlin.String? = null
        /**
         * The ARN of the event bus that sends events to the archive.
         */
        public var eventSourceArn: kotlin.String? = null
        /**
         * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
         *
         * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to encrypt the archive.
         *
         * For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *Key Management Service Developer Guide*.
         *
         * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we strongly recommend you also specify a customer managed key for any archives for the event bus as well.
         *
         * For more information, see [Encrypting archives](https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html) in the *Amazon EventBridge User Guide*.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely
         */
        public var retentionDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.CreateArchiveRequest) : this() {
            this.archiveName = x.archiveName
            this.description = x.description
            this.eventPattern = x.eventPattern
            this.eventSourceArn = x.eventSourceArn
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.retentionDays = x.retentionDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.CreateArchiveRequest = CreateArchiveRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
