// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON string which you can use to limit the event bus permissions you are granting to only accounts that fulfill the condition. Currently, the only supported condition is membership in a certain Amazon Web Services organization. The string must contain `Type`, `Key`, and `Value` fields. The `Value` field specifies the ID of the Amazon Web Services organization. Following is an example value for `Condition`:
 *
 * `'{"Type" : "StringEquals", "Key": "aws:PrincipalOrgID", "Value": "o-1234567890"}'`
 */
public class Condition private constructor(builder: Builder) {
    /**
     * Specifies the key for the condition. Currently the only supported key is `aws:PrincipalOrgID`.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Specifies the type of condition. Currently the only supported value is `StringEquals`.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * Specifies the value for the key. Currently, this must be the ID of the organization.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.Condition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Condition(")
        append("key=$key,")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (type.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Condition

        if (key != other.key) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.Condition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the key for the condition. Currently the only supported key is `aws:PrincipalOrgID`.
         */
        public var key: kotlin.String? = null
        /**
         * Specifies the type of condition. Currently the only supported value is `StringEquals`.
         */
        public var type: kotlin.String? = null
        /**
         * Specifies the value for the key. Currently, this must be the ID of the organization.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.Condition) : this() {
            this.key = x.key
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.Condition = Condition(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (type == null) type = ""
            if (value == null) value = ""
            return this
        }
    }
}
