// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.endpoints

import aws.sdk.kotlin.services.eventbridge.endpoints.internal.partition
import aws.smithy.kotlin.runtime.businessmetrics.ServiceEndpointOverride
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.client.endpoints.functions.isValidHostLabel
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.http.auth.sigV4A
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEventBridgeEndpointProvider: EventBridgeEndpointProvider {
    public override suspend fun resolveEndpoint(params: EventBridgeEndpointParameters): Endpoint {
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                !(params.endpoint != null) &&
                params.region != null &&
                partitionResult?.name == "aws-us-gov" &&
                params.useFips == true &&
                params.useDualStack == true
            ) {
                return Endpoint(
                    Url.parse("https://events.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                )
            }
        }
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                params.endpointId != null &&
                params.region != null
            ) {
                if (
                    isValidHostLabel(params.endpointId, true)
                ) {
                    if (
                        params.useFips == false
                    ) {
                        if (
                            params.endpoint != null
                        ) {
                            return Endpoint(
                                Url.parse(params.endpoint),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4A(
                                            serviceName = "events",
                                            disableDoubleUriEncode = false,
                                            signingRegionSet = listOf(
                                                "*",
                                            ),
                                        ),
                                    )
                                    ServiceEndpointOverride to true
                                },
                            )
                        }
                        if (
                            params.useDualStack == true
                        ) {
                            if (
                                true == partitionResult?.supportsDualStack
                            ) {
                                return Endpoint(
                                    Url.parse("https://${params.endpointId}.endpoint.events.${partitionResult?.dualStackDnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4A(
                                                serviceName = "events",
                                                disableDoubleUriEncode = false,
                                                signingRegionSet = listOf(
                                                    "*",
                                                ),
                                            ),
                                        )
                                    },
                                )
                            }
                            throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                        }
                        return Endpoint(
                            Url.parse("https://${params.endpointId}.endpoint.events.${partitionResult?.dnsSuffix}"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4A(
                                        serviceName = "events",
                                        disableDoubleUriEncode = false,
                                        signingRegionSet = listOf(
                                            "*",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    throw EndpointProviderException("Invalid Configuration: FIPS is not supported with EventBridge multi-region endpoints.")
                }
                throw EndpointProviderException("EndpointId must be a valid host label.")
            }
        }
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
                attributes = attributesOf {
                    ServiceEndpointOverride to true
                },
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://events-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            if (
                                params.region == "us-gov-east-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://events.us-gov-east-1.amazonaws.com"),
                                )
                            }
                            if (
                                params.region == "us-gov-west-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://events.us-gov-west-1.amazonaws.com"),
                                )
                            }
                            return Endpoint(
                                Url.parse("https://events-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://events.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://events.${params.region}.${partitionResult?.dnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
