// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.auth

import aws.sdk.kotlin.services.eventbridge.endpoints.EventBridgeEndpointParameters

public class EventBridgeAuthSchemeParameters private constructor(builder: Builder) {
    public val endpointParameters: EventBridgeEndpointParameters? = builder.endpointParameters
    public val operationName: String = requireNotNull(builder.operationName) { "operationName is a required auth scheme parameter" }
    public companion object {
        public inline operator fun invoke(block: Builder.() -> kotlin.Unit): EventBridgeAuthSchemeParameters = Builder().apply(block).build()
    }

    public fun toBuilder(): Builder = Builder().apply {
        endpointParameters = this@EventBridgeAuthSchemeParameters.endpointParameters
        operationName = this@EventBridgeAuthSchemeParameters.operationName
    }

    public class Builder {
        /**
         * The parameters used for endpoint resolution. The default implementation of this interface
         * relies on endpoint metadata to resolve auth scheme candidates.
         */
        public var endpointParameters: EventBridgeEndpointParameters? = null

        /**
         * The name of the operation currently being invoked.
         */
        public var operationName: String? = null

        @PublishedApi
        internal fun build(): EventBridgeAuthSchemeParameters = EventBridgeAuthSchemeParameters(this)
    }

    override fun toString(): String = buildString {
        append("EventBridgeAuthSchemeParameters(")
        append("endpointParameters=$endpointParameters,")
        append("operationName=$operationName)")
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is EventBridgeAuthSchemeParameters) return false
        if (this.endpointParameters != other.endpointParameters) return false
        if (this.operationName != other.operationName) return false
        return true
    }

    override fun hashCode(): Int {
        var result = endpointParameters?.hashCode() ?: 0
        result = 31 * result + (operationName?.hashCode() ?: 0)
        return result
    }

    public fun copy(block: Builder.() -> Unit = {}): EventBridgeAuthSchemeParameters {
        return Builder().apply {
            endpointParameters = this@EventBridgeAuthSchemeParameters.endpointParameters
            operationName = this@EventBridgeAuthSchemeParameters.operationName
            block()
        }
        .build()
    }
}
