// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.serde

import aws.sdk.kotlin.services.eventbridge.model.ApiDestinationHttpMethod
import aws.sdk.kotlin.services.eventbridge.model.ApiDestinationState
import aws.sdk.kotlin.services.eventbridge.model.DescribeApiDestinationResponse
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeApiDestinationOperationDeserializer: HttpDeserialize<DescribeApiDestinationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeApiDestinationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeApiDestinationError(context, call)
        }
        val builder = DescribeApiDestinationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeApiDestinationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeApiDestinationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EventBridgeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeApiDestinationOperationBody(builder: DescribeApiDestinationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIDESTINATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApiDestinationArn"))
    val APIDESTINATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ApiDestinationState"))
    val CONNECTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val HTTPMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HttpMethod"))
    val INVOCATIONENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InvocationEndpoint"))
    val INVOCATIONRATELIMITPERSECOND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InvocationRateLimitPerSecond"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIDESTINATIONARN_DESCRIPTOR)
        field(APIDESTINATIONSTATE_DESCRIPTOR)
        field(CONNECTIONARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HTTPMETHOD_DESCRIPTOR)
        field(INVOCATIONENDPOINT_DESCRIPTOR)
        field(INVOCATIONRATELIMITPERSECOND_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIDESTINATIONARN_DESCRIPTOR.index -> builder.apiDestinationArn = deserializeString()
                APIDESTINATIONSTATE_DESCRIPTOR.index -> builder.apiDestinationState = deserializeString().let { ApiDestinationState.fromValue(it) }
                CONNECTIONARN_DESCRIPTOR.index -> builder.connectionArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HTTPMETHOD_DESCRIPTOR.index -> builder.httpMethod = deserializeString().let { ApiDestinationHttpMethod.fromValue(it) }
                INVOCATIONENDPOINT_DESCRIPTOR.index -> builder.invocationEndpoint = deserializeString()
                INVOCATIONRATELIMITPERSECOND_DESCRIPTOR.index -> builder.invocationRateLimitPerSecond = deserializeInt()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
